/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.rekognition.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * Face JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class FaceUnmarshaller implements Unmarshaller<Face, JsonUnmarshallerContext> {

    public Face unmarshall(JsonUnmarshallerContext context) throws Exception {
        Face.Builder faceBuilder = Face.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("FaceId", targetDepth)) {
                    context.nextToken();
                    faceBuilder.faceId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("BoundingBox", targetDepth)) {
                    context.nextToken();
                    faceBuilder.boundingBox(BoundingBoxUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ImageId", targetDepth)) {
                    context.nextToken();
                    faceBuilder.imageId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ExternalImageId", targetDepth)) {
                    context.nextToken();
                    faceBuilder.externalImageId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Confidence", targetDepth)) {
                    context.nextToken();
                    faceBuilder.confidence(context.getUnmarshaller(Float.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return faceBuilder.build();
    }

    private static FaceUnmarshaller INSTANCE;

    public static FaceUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new FaceUnmarshaller();
        return INSTANCE;
    }
}