/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.EmotionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The emotions detected on the face, and the confidence level in the determination. For example, HAPPY, SAD, and ANGRY.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Emotion implements StructuredPojo, ToCopyableBuilder<Emotion.Builder, Emotion> {
    private final String type;

    private final Float confidence;

    private Emotion(BuilderImpl builder) {
        this.type = builder.type;
        this.confidence = builder.confidence;
    }

    /**
     * <p>
     * Type of emotion detected.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EmotionName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of emotion detected.
     * @see EmotionName
     */
    public EmotionName type() {
        return EmotionName.fromValue(type);
    }

    /**
     * <p>
     * Type of emotion detected.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EmotionName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of emotion detected.
     * @see EmotionName
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Level of confidence in the determination.
     * </p>
     * 
     * @return Level of confidence in the determination.
     */
    public Float confidence() {
        return confidence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Emotion)) {
            return false;
        }
        Emotion other = (Emotion) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(confidence(), other.confidence());
    }

    @Override
    public String toString() {
        return ToString.builder("Emotion").add("Type", typeAsString()).add("Confidence", confidence()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.of(clazz.cast(typeAsString()));
        case "Confidence":
            return Optional.of(clazz.cast(confidence()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EmotionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Emotion> {
        /**
         * <p>
         * Type of emotion detected.
         * </p>
         * 
         * @param type
         *        Type of emotion detected.
         * @see EmotionName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EmotionName
         */
        Builder type(String type);

        /**
         * <p>
         * Type of emotion detected.
         * </p>
         * 
         * @param type
         *        Type of emotion detected.
         * @see EmotionName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EmotionName
         */
        Builder type(EmotionName type);

        /**
         * <p>
         * Level of confidence in the determination.
         * </p>
         * 
         * @param confidence
         *        Level of confidence in the determination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Float confidence);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Float confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(Emotion model) {
            type(model.type);
            confidence(model.confidence);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EmotionName type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Float getConfidence() {
            return confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public Emotion build() {
            return new Emotion(this);
        }
    }
}
