/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class IndexFacesResponse extends RekognitionResponse implements
        ToCopyableBuilder<IndexFacesResponse.Builder, IndexFacesResponse> {
    private final List<FaceRecord> faceRecords;

    private final String orientationCorrection;

    private IndexFacesResponse(BuilderImpl builder) {
        super(builder);
        this.faceRecords = builder.faceRecords;
        this.orientationCorrection = builder.orientationCorrection;
    }

    /**
     * <p>
     * An array of faces detected and added to the collection. For more information, see <a>howitworks-index-faces</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of faces detected and added to the collection. For more information, see
     *         <a>howitworks-index-faces</a>.
     */
    public List<FaceRecord> faceRecords() {
        return faceRecords;
    }

    /**
     * <p>
     * The orientation of the input image (counterclockwise direction). If your application displays the image, you can
     * use this value to correct image orientation. The bounding box coordinates returned in <code>FaceRecords</code>
     * represent face locations before the image orientation is corrected.
     * </p>
     * <note>
     * <p>
     * If the input image is in jpeg format, it might contain exchangeable image (Exif) metadata. If so, and the Exif
     * metadata populates the orientation field, the value of <code>OrientationCorrection</code> is null and the
     * bounding box coordinates in <code>FaceRecords</code> represent face locations after Exif metadata is used to
     * correct the image orientation. Images in .png format don't contain Exif metadata.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #orientationCorrection} will return {@link OrientationCorrection#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #orientationCorrectionAsString}.
     * </p>
     * 
     * @return The orientation of the input image (counterclockwise direction). If your application displays the image,
     *         you can use this value to correct image orientation. The bounding box coordinates returned in
     *         <code>FaceRecords</code> represent face locations before the image orientation is corrected. </p> <note>
     *         <p>
     *         If the input image is in jpeg format, it might contain exchangeable image (Exif) metadata. If so, and the
     *         Exif metadata populates the orientation field, the value of <code>OrientationCorrection</code> is null
     *         and the bounding box coordinates in <code>FaceRecords</code> represent face locations after Exif metadata
     *         is used to correct the image orientation. Images in .png format don't contain Exif metadata.
     *         </p>
     * @see OrientationCorrection
     */
    public OrientationCorrection orientationCorrection() {
        return OrientationCorrection.fromValue(orientationCorrection);
    }

    /**
     * <p>
     * The orientation of the input image (counterclockwise direction). If your application displays the image, you can
     * use this value to correct image orientation. The bounding box coordinates returned in <code>FaceRecords</code>
     * represent face locations before the image orientation is corrected.
     * </p>
     * <note>
     * <p>
     * If the input image is in jpeg format, it might contain exchangeable image (Exif) metadata. If so, and the Exif
     * metadata populates the orientation field, the value of <code>OrientationCorrection</code> is null and the
     * bounding box coordinates in <code>FaceRecords</code> represent face locations after Exif metadata is used to
     * correct the image orientation. Images in .png format don't contain Exif metadata.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #orientationCorrection} will return {@link OrientationCorrection#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #orientationCorrectionAsString}.
     * </p>
     * 
     * @return The orientation of the input image (counterclockwise direction). If your application displays the image,
     *         you can use this value to correct image orientation. The bounding box coordinates returned in
     *         <code>FaceRecords</code> represent face locations before the image orientation is corrected. </p> <note>
     *         <p>
     *         If the input image is in jpeg format, it might contain exchangeable image (Exif) metadata. If so, and the
     *         Exif metadata populates the orientation field, the value of <code>OrientationCorrection</code> is null
     *         and the bounding box coordinates in <code>FaceRecords</code> represent face locations after Exif metadata
     *         is used to correct the image orientation. Images in .png format don't contain Exif metadata.
     *         </p>
     * @see OrientationCorrection
     */
    public String orientationCorrectionAsString() {
        return orientationCorrection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(faceRecords());
        hashCode = 31 * hashCode + Objects.hashCode(orientationCorrectionAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexFacesResponse)) {
            return false;
        }
        IndexFacesResponse other = (IndexFacesResponse) obj;
        return Objects.equals(faceRecords(), other.faceRecords())
                && Objects.equals(orientationCorrectionAsString(), other.orientationCorrectionAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("IndexFacesResponse").add("FaceRecords", faceRecords())
                .add("OrientationCorrection", orientationCorrectionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FaceRecords":
            return Optional.of(clazz.cast(faceRecords()));
        case "OrientationCorrection":
            return Optional.of(clazz.cast(orientationCorrectionAsString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends RekognitionResponse.Builder, CopyableBuilder<Builder, IndexFacesResponse> {
        /**
         * <p>
         * An array of faces detected and added to the collection. For more information, see
         * <a>howitworks-index-faces</a>.
         * </p>
         * 
         * @param faceRecords
         *        An array of faces detected and added to the collection. For more information, see
         *        <a>howitworks-index-faces</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceRecords(Collection<FaceRecord> faceRecords);

        /**
         * <p>
         * An array of faces detected and added to the collection. For more information, see
         * <a>howitworks-index-faces</a>.
         * </p>
         * 
         * @param faceRecords
         *        An array of faces detected and added to the collection. For more information, see
         *        <a>howitworks-index-faces</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceRecords(FaceRecord... faceRecords);

        /**
         * <p>
         * An array of faces detected and added to the collection. For more information, see
         * <a>howitworks-index-faces</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FaceRecord>.Builder} avoiding the need to
         * create one manually via {@link List<FaceRecord>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FaceRecord>.Builder#build()} is called immediately and its
         * result is passed to {@link #faceRecords(List<FaceRecord>)}.
         * 
         * @param faceRecords
         *        a consumer that will call methods on {@link List<FaceRecord>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #faceRecords(List<FaceRecord>)
         */
        Builder faceRecords(Consumer<FaceRecord.Builder>... faceRecords);

        /**
         * <p>
         * The orientation of the input image (counterclockwise direction). If your application displays the image, you
         * can use this value to correct image orientation. The bounding box coordinates returned in
         * <code>FaceRecords</code> represent face locations before the image orientation is corrected.
         * </p>
         * <note>
         * <p>
         * If the input image is in jpeg format, it might contain exchangeable image (Exif) metadata. If so, and the
         * Exif metadata populates the orientation field, the value of <code>OrientationCorrection</code> is null and
         * the bounding box coordinates in <code>FaceRecords</code> represent face locations after Exif metadata is used
         * to correct the image orientation. Images in .png format don't contain Exif metadata.
         * </p>
         * </note>
         * 
         * @param orientationCorrection
         *        The orientation of the input image (counterclockwise direction). If your application displays the
         *        image, you can use this value to correct image orientation. The bounding box coordinates returned in
         *        <code>FaceRecords</code> represent face locations before the image orientation is corrected. </p>
         *        <note>
         *        <p>
         *        If the input image is in jpeg format, it might contain exchangeable image (Exif) metadata. If so, and
         *        the Exif metadata populates the orientation field, the value of <code>OrientationCorrection</code> is
         *        null and the bounding box coordinates in <code>FaceRecords</code> represent face locations after Exif
         *        metadata is used to correct the image orientation. Images in .png format don't contain Exif metadata.
         *        </p>
         * @see OrientationCorrection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrientationCorrection
         */
        Builder orientationCorrection(String orientationCorrection);

        /**
         * <p>
         * The orientation of the input image (counterclockwise direction). If your application displays the image, you
         * can use this value to correct image orientation. The bounding box coordinates returned in
         * <code>FaceRecords</code> represent face locations before the image orientation is corrected.
         * </p>
         * <note>
         * <p>
         * If the input image is in jpeg format, it might contain exchangeable image (Exif) metadata. If so, and the
         * Exif metadata populates the orientation field, the value of <code>OrientationCorrection</code> is null and
         * the bounding box coordinates in <code>FaceRecords</code> represent face locations after Exif metadata is used
         * to correct the image orientation. Images in .png format don't contain Exif metadata.
         * </p>
         * </note>
         * 
         * @param orientationCorrection
         *        The orientation of the input image (counterclockwise direction). If your application displays the
         *        image, you can use this value to correct image orientation. The bounding box coordinates returned in
         *        <code>FaceRecords</code> represent face locations before the image orientation is corrected. </p>
         *        <note>
         *        <p>
         *        If the input image is in jpeg format, it might contain exchangeable image (Exif) metadata. If so, and
         *        the Exif metadata populates the orientation field, the value of <code>OrientationCorrection</code> is
         *        null and the bounding box coordinates in <code>FaceRecords</code> represent face locations after Exif
         *        metadata is used to correct the image orientation. Images in .png format don't contain Exif metadata.
         *        </p>
         * @see OrientationCorrection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrientationCorrection
         */
        Builder orientationCorrection(OrientationCorrection orientationCorrection);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private List<FaceRecord> faceRecords;

        private String orientationCorrection;

        private BuilderImpl() {
        }

        private BuilderImpl(IndexFacesResponse model) {
            super(model);
            faceRecords(model.faceRecords);
            orientationCorrection(model.orientationCorrection);
        }

        public final Collection<FaceRecord.Builder> getFaceRecords() {
            return faceRecords != null ? faceRecords.stream().map(FaceRecord::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder faceRecords(Collection<FaceRecord> faceRecords) {
            this.faceRecords = FaceRecordListCopier.copy(faceRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceRecords(FaceRecord... faceRecords) {
            faceRecords(Arrays.asList(faceRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceRecords(Consumer<FaceRecord.Builder>... faceRecords) {
            faceRecords(Stream.of(faceRecords).map(c -> FaceRecord.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFaceRecords(Collection<FaceRecord.BuilderImpl> faceRecords) {
            this.faceRecords = FaceRecordListCopier.copyFromBuilder(faceRecords);
        }

        public final String getOrientationCorrection() {
            return orientationCorrection;
        }

        @Override
        public final Builder orientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
            return this;
        }

        @Override
        public final Builder orientationCorrection(OrientationCorrection orientationCorrection) {
            this.orientationCorrection(orientationCorrection.toString());
            return this;
        }

        public final void setOrientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
        }

        @Override
        public IndexFacesResponse build() {
            return new IndexFacesResponse(this);
        }
    }
}
