/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.transform;

import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.FaceDetail;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link FaceDetail} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class FaceDetailMarshaller {
    private static final MarshallingInfo<StructuredPojo> BOUNDINGBOX_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BoundingBox")
            .isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> AGERANGE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AgeRange").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> SMILE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Smile").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> EYEGLASSES_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Eyeglasses").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> SUNGLASSES_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Sunglasses").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> GENDER_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Gender").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> BEARD_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Beard").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> MUSTACHE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Mustache").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> EYESOPEN_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EyesOpen").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> MOUTHOPEN_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MouthOpen").isBinary(false).build();

    private static final MarshallingInfo<List> EMOTIONS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Emotions").isBinary(false).build();

    private static final MarshallingInfo<List> LANDMARKS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Landmarks").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> POSE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Pose").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> QUALITY_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Quality").isBinary(false).build();

    private static final MarshallingInfo<Float> CONFIDENCE_BINDING = MarshallingInfo.builder(MarshallingType.FLOAT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Confidence").isBinary(false).build();

    private static final FaceDetailMarshaller INSTANCE = new FaceDetailMarshaller();

    private FaceDetailMarshaller() {
    }

    public static FaceDetailMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(FaceDetail faceDetail, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(faceDetail, "faceDetail");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(faceDetail.boundingBox(), BOUNDINGBOX_BINDING);
            protocolMarshaller.marshall(faceDetail.ageRange(), AGERANGE_BINDING);
            protocolMarshaller.marshall(faceDetail.smile(), SMILE_BINDING);
            protocolMarshaller.marshall(faceDetail.eyeglasses(), EYEGLASSES_BINDING);
            protocolMarshaller.marshall(faceDetail.sunglasses(), SUNGLASSES_BINDING);
            protocolMarshaller.marshall(faceDetail.gender(), GENDER_BINDING);
            protocolMarshaller.marshall(faceDetail.beard(), BEARD_BINDING);
            protocolMarshaller.marshall(faceDetail.mustache(), MUSTACHE_BINDING);
            protocolMarshaller.marshall(faceDetail.eyesOpen(), EYESOPEN_BINDING);
            protocolMarshaller.marshall(faceDetail.mouthOpen(), MOUTHOPEN_BINDING);
            protocolMarshaller.marshall(faceDetail.emotions(), EMOTIONS_BINDING);
            protocolMarshaller.marshall(faceDetail.landmarks(), LANDMARKS_BINDING);
            protocolMarshaller.marshall(faceDetail.pose(), POSE_BINDING);
            protocolMarshaller.marshall(faceDetail.quality(), QUALITY_BINDING);
            protocolMarshaller.marshall(faceDetail.confidence(), CONFIDENCE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
