/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.BoundingBox;
import software.amazon.awssdk.services.rekognition.model.ImageQuality;
import software.amazon.awssdk.services.rekognition.model.Landmark;
import software.amazon.awssdk.services.rekognition.model.LandmarksCopier;
import software.amazon.awssdk.services.rekognition.model.Pose;
import software.amazon.awssdk.services.rekognition.transform.ComparedFaceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ComparedFace
implements StructuredPojo,
ToCopyableBuilder<Builder, ComparedFace> {
    private final BoundingBox boundingBox;
    private final Float confidence;
    private final List<Landmark> landmarks;
    private final Pose pose;
    private final ImageQuality quality;

    private ComparedFace(BuilderImpl builder) {
        this.boundingBox = builder.boundingBox;
        this.confidence = builder.confidence;
        this.landmarks = builder.landmarks;
        this.pose = builder.pose;
        this.quality = builder.quality;
    }

    public BoundingBox boundingBox() {
        return this.boundingBox;
    }

    public Float confidence() {
        return this.confidence;
    }

    public List<Landmark> landmarks() {
        return this.landmarks;
    }

    public Pose pose() {
        return this.pose;
    }

    public ImageQuality quality() {
        return this.quality;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.boundingBox());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.landmarks());
        hashCode = 31 * hashCode + Objects.hashCode(this.pose());
        hashCode = 31 * hashCode + Objects.hashCode(this.quality());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComparedFace)) {
            return false;
        }
        ComparedFace other = (ComparedFace)obj;
        return Objects.equals(this.boundingBox(), other.boundingBox()) && Objects.equals(this.confidence(), other.confidence()) && Objects.equals(this.landmarks(), other.landmarks()) && Objects.equals(this.pose(), other.pose()) && Objects.equals(this.quality(), other.quality());
    }

    public String toString() {
        return ToString.builder((String)"ComparedFace").add("BoundingBox", (Object)this.boundingBox()).add("Confidence", (Object)this.confidence()).add("Landmarks", this.landmarks()).add("Pose", (Object)this.pose()).add("Quality", (Object)this.quality()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BoundingBox": {
                return Optional.of(clazz.cast(this.boundingBox()));
            }
            case "Confidence": {
                return Optional.of(clazz.cast(this.confidence()));
            }
            case "Landmarks": {
                return Optional.of(clazz.cast(this.landmarks()));
            }
            case "Pose": {
                return Optional.of(clazz.cast(this.pose()));
            }
            case "Quality": {
                return Optional.of(clazz.cast(this.quality()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComparedFaceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private BoundingBox boundingBox;
        private Float confidence;
        private List<Landmark> landmarks;
        private Pose pose;
        private ImageQuality quality;

        private BuilderImpl() {
        }

        private BuilderImpl(ComparedFace model) {
            this.boundingBox(model.boundingBox);
            this.confidence(model.confidence);
            this.landmarks(model.landmarks);
            this.pose(model.pose);
            this.quality(model.quality);
        }

        public final BoundingBox.Builder getBoundingBox() {
            return this.boundingBox != null ? this.boundingBox.toBuilder() : null;
        }

        @Override
        public final Builder boundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        public final void setBoundingBox(BoundingBox.BuilderImpl boundingBox) {
            this.boundingBox = boundingBox != null ? boundingBox.build() : null;
        }

        public final Float getConfidence() {
            return this.confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        public final Collection<Landmark.Builder> getLandmarks() {
            return this.landmarks != null ? (Collection)this.landmarks.stream().map(Landmark::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder landmarks(Collection<Landmark> landmarks) {
            this.landmarks = LandmarksCopier.copy(landmarks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder landmarks(Landmark ... landmarks) {
            this.landmarks(Arrays.asList(landmarks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder landmarks(Consumer<Landmark.Builder> ... landmarks) {
            this.landmarks(Stream.of(landmarks).map(c -> (Landmark)((Landmark.Builder)Landmark.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLandmarks(Collection<Landmark.BuilderImpl> landmarks) {
            this.landmarks = LandmarksCopier.copyFromBuilder(landmarks);
        }

        public final Pose.Builder getPose() {
            return this.pose != null ? this.pose.toBuilder() : null;
        }

        @Override
        public final Builder pose(Pose pose) {
            this.pose = pose;
            return this;
        }

        public final void setPose(Pose.BuilderImpl pose) {
            this.pose = pose != null ? pose.build() : null;
        }

        public final ImageQuality.Builder getQuality() {
            return this.quality != null ? this.quality.toBuilder() : null;
        }

        @Override
        public final Builder quality(ImageQuality quality) {
            this.quality = quality;
            return this;
        }

        public final void setQuality(ImageQuality.BuilderImpl quality) {
            this.quality = quality != null ? quality.build() : null;
        }

        public ComparedFace build() {
            return new ComparedFace(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ComparedFace> {
        public Builder boundingBox(BoundingBox var1);

        default public Builder boundingBox(Consumer<BoundingBox.Builder> boundingBox) {
            return this.boundingBox((BoundingBox)((BoundingBox.Builder)BoundingBox.builder().apply(boundingBox)).build());
        }

        public Builder confidence(Float var1);

        public Builder landmarks(Collection<Landmark> var1);

        public Builder landmarks(Landmark ... var1);

        public Builder landmarks(Consumer<Landmark.Builder> ... var1);

        public Builder pose(Pose var1);

        default public Builder pose(Consumer<Pose.Builder> pose) {
            return this.pose((Pose)((Pose.Builder)Pose.builder().apply(pose)).build());
        }

        public Builder quality(ImageQuality var1);

        default public Builder quality(Consumer<ImageQuality.Builder> quality) {
            return this.quality((ImageQuality)((ImageQuality.Builder)ImageQuality.builder().apply(quality)).build());
        }
    }
}

