/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteCollectionRequest
extends RekognitionRequest
implements ToCopyableBuilder<Builder, DeleteCollectionRequest> {
    private final String collectionId;

    private DeleteCollectionRequest(BuilderImpl builder) {
        super(builder);
        this.collectionId = builder.collectionId;
    }

    public String collectionId() {
        return this.collectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCollectionRequest)) {
            return false;
        }
        DeleteCollectionRequest other = (DeleteCollectionRequest)((Object)obj);
        return Objects.equals(this.collectionId(), other.collectionId());
    }

    public String toString() {
        return ToString.builder((String)"DeleteCollectionRequest").add("CollectionId", (Object)this.collectionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CollectionId": {
                return Optional.of(clazz.cast(this.collectionId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RekognitionRequest.BuilderImpl
    implements Builder {
        private String collectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCollectionRequest model) {
            super(model);
            this.collectionId(model.collectionId);
        }

        public final String getCollectionId() {
            return this.collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteCollectionRequest build() {
            return new DeleteCollectionRequest(this);
        }
    }

    public static interface Builder
    extends RekognitionRequest.Builder,
    CopyableBuilder<Builder, DeleteCollectionRequest> {
        public Builder collectionId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

