/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.rekognition.model.FaceIdListCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteFacesResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, DeleteFacesResponse> {
    private final List<String> deletedFaces;

    private DeleteFacesResponse(BuilderImpl builder) {
        super(builder);
        this.deletedFaces = builder.deletedFaces;
    }

    public List<String> deletedFaces() {
        return this.deletedFaces;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deletedFaces());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFacesResponse)) {
            return false;
        }
        DeleteFacesResponse other = (DeleteFacesResponse)((Object)obj);
        return Objects.equals(this.deletedFaces(), other.deletedFaces());
    }

    public String toString() {
        return ToString.builder((String)"DeleteFacesResponse").add("DeletedFaces", this.deletedFaces()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeletedFaces": {
                return Optional.of(clazz.cast(this.deletedFaces()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private List<String> deletedFaces;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFacesResponse model) {
            super(model);
            this.deletedFaces(model.deletedFaces);
        }

        public final Collection<String> getDeletedFaces() {
            return this.deletedFaces;
        }

        @Override
        public final Builder deletedFaces(Collection<String> deletedFaces) {
            this.deletedFaces = FaceIdListCopier.copy(deletedFaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deletedFaces(String ... deletedFaces) {
            this.deletedFaces(Arrays.asList(deletedFaces));
            return this;
        }

        public final void setDeletedFaces(Collection<String> deletedFaces) {
            this.deletedFaces = FaceIdListCopier.copy(deletedFaces);
        }

        @Override
        public DeleteFacesResponse build() {
            return new DeleteFacesResponse(this);
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    CopyableBuilder<Builder, DeleteFacesResponse> {
        public Builder deletedFaces(Collection<String> var1);

        public Builder deletedFaces(String ... var1);
    }
}

