/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.rekognition.model.ModerationLabel;
import software.amazon.awssdk.services.rekognition.model.ModerationLabelsCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DetectModerationLabelsResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, DetectModerationLabelsResponse> {
    private final List<ModerationLabel> moderationLabels;

    private DetectModerationLabelsResponse(BuilderImpl builder) {
        super(builder);
        this.moderationLabels = builder.moderationLabels;
    }

    public List<ModerationLabel> moderationLabels() {
        return this.moderationLabels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.moderationLabels());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectModerationLabelsResponse)) {
            return false;
        }
        DetectModerationLabelsResponse other = (DetectModerationLabelsResponse)((Object)obj);
        return Objects.equals(this.moderationLabels(), other.moderationLabels());
    }

    public String toString() {
        return ToString.builder((String)"DetectModerationLabelsResponse").add("ModerationLabels", this.moderationLabels()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModerationLabels": {
                return Optional.of(clazz.cast(this.moderationLabels()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private List<ModerationLabel> moderationLabels;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectModerationLabelsResponse model) {
            super(model);
            this.moderationLabels(model.moderationLabels);
        }

        public final Collection<ModerationLabel.Builder> getModerationLabels() {
            return this.moderationLabels != null ? (Collection)this.moderationLabels.stream().map(ModerationLabel::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder moderationLabels(Collection<ModerationLabel> moderationLabels) {
            this.moderationLabels = ModerationLabelsCopier.copy(moderationLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder moderationLabels(ModerationLabel ... moderationLabels) {
            this.moderationLabels(Arrays.asList(moderationLabels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder moderationLabels(Consumer<ModerationLabel.Builder> ... moderationLabels) {
            this.moderationLabels(Stream.of(moderationLabels).map(c -> (ModerationLabel)((ModerationLabel.Builder)ModerationLabel.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setModerationLabels(Collection<ModerationLabel.BuilderImpl> moderationLabels) {
            this.moderationLabels = ModerationLabelsCopier.copyFromBuilder(moderationLabels);
        }

        @Override
        public DetectModerationLabelsResponse build() {
            return new DetectModerationLabelsResponse(this);
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    CopyableBuilder<Builder, DetectModerationLabelsResponse> {
        public Builder moderationLabels(Collection<ModerationLabel> var1);

        public Builder moderationLabels(ModerationLabel ... var1);

        public Builder moderationLabels(Consumer<ModerationLabel.Builder> ... var1);
    }
}

