/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.rekognition.model.FaceRecord;
import software.amazon.awssdk.services.rekognition.model.FaceRecordListCopier;
import software.amazon.awssdk.services.rekognition.model.OrientationCorrection;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class IndexFacesResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, IndexFacesResponse> {
    private final List<FaceRecord> faceRecords;
    private final String orientationCorrection;

    private IndexFacesResponse(BuilderImpl builder) {
        super(builder);
        this.faceRecords = builder.faceRecords;
        this.orientationCorrection = builder.orientationCorrection;
    }

    public List<FaceRecord> faceRecords() {
        return this.faceRecords;
    }

    public OrientationCorrection orientationCorrection() {
        return OrientationCorrection.fromValue(this.orientationCorrection);
    }

    public String orientationCorrectionAsString() {
        return this.orientationCorrection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.faceRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.orientationCorrectionAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexFacesResponse)) {
            return false;
        }
        IndexFacesResponse other = (IndexFacesResponse)((Object)obj);
        return Objects.equals(this.faceRecords(), other.faceRecords()) && Objects.equals(this.orientationCorrectionAsString(), other.orientationCorrectionAsString());
    }

    public String toString() {
        return ToString.builder((String)"IndexFacesResponse").add("FaceRecords", this.faceRecords()).add("OrientationCorrection", (Object)this.orientationCorrectionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FaceRecords": {
                return Optional.of(clazz.cast(this.faceRecords()));
            }
            case "OrientationCorrection": {
                return Optional.of(clazz.cast(this.orientationCorrectionAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private List<FaceRecord> faceRecords;
        private String orientationCorrection;

        private BuilderImpl() {
        }

        private BuilderImpl(IndexFacesResponse model) {
            super(model);
            this.faceRecords(model.faceRecords);
            this.orientationCorrection(model.orientationCorrection);
        }

        public final Collection<FaceRecord.Builder> getFaceRecords() {
            return this.faceRecords != null ? (Collection)this.faceRecords.stream().map(FaceRecord::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder faceRecords(Collection<FaceRecord> faceRecords) {
            this.faceRecords = FaceRecordListCopier.copy(faceRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceRecords(FaceRecord ... faceRecords) {
            this.faceRecords(Arrays.asList(faceRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceRecords(Consumer<FaceRecord.Builder> ... faceRecords) {
            this.faceRecords(Stream.of(faceRecords).map(c -> (FaceRecord)((FaceRecord.Builder)FaceRecord.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFaceRecords(Collection<FaceRecord.BuilderImpl> faceRecords) {
            this.faceRecords = FaceRecordListCopier.copyFromBuilder(faceRecords);
        }

        public final String getOrientationCorrection() {
            return this.orientationCorrection;
        }

        @Override
        public final Builder orientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
            return this;
        }

        @Override
        public final Builder orientationCorrection(OrientationCorrection orientationCorrection) {
            this.orientationCorrection(orientationCorrection.toString());
            return this;
        }

        public final void setOrientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
        }

        @Override
        public IndexFacesResponse build() {
            return new IndexFacesResponse(this);
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    CopyableBuilder<Builder, IndexFacesResponse> {
        public Builder faceRecords(Collection<FaceRecord> var1);

        public Builder faceRecords(FaceRecord ... var1);

        public Builder faceRecords(Consumer<FaceRecord.Builder> ... var1);

        public Builder orientationCorrection(String var1);

        public Builder orientationCorrection(OrientationCorrection var1);
    }
}

