/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.LandmarkType;
import software.amazon.awssdk.services.rekognition.transform.LandmarkMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Landmark
implements StructuredPojo,
ToCopyableBuilder<Builder, Landmark> {
    private final String type;
    private final Float x;
    private final Float y;

    private Landmark(BuilderImpl builder) {
        this.type = builder.type;
        this.x = builder.x;
        this.y = builder.y;
    }

    public LandmarkType type() {
        return LandmarkType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Float x() {
        return this.x;
    }

    public Float y() {
        return this.y;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.x());
        hashCode = 31 * hashCode + Objects.hashCode(this.y());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Landmark)) {
            return false;
        }
        Landmark other = (Landmark)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.x(), other.x()) && Objects.equals(this.y(), other.y());
    }

    public String toString() {
        return ToString.builder((String)"Landmark").add("Type", (Object)this.typeAsString()).add("X", (Object)this.x()).add("Y", (Object)this.y()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.of(clazz.cast(this.typeAsString()));
            }
            case "X": {
                return Optional.of(clazz.cast(this.x()));
            }
            case "Y": {
                return Optional.of(clazz.cast(this.y()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LandmarkMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private Float x;
        private Float y;

        private BuilderImpl() {
        }

        private BuilderImpl(Landmark model) {
            this.type(model.type);
            this.x(model.x);
            this.y(model.y);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(LandmarkType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Float getX() {
            return this.x;
        }

        @Override
        public final Builder x(Float x) {
            this.x = x;
            return this;
        }

        public final void setX(Float x) {
            this.x = x;
        }

        public final Float getY() {
            return this.y;
        }

        @Override
        public final Builder y(Float y) {
            this.y = y;
            return this;
        }

        public final void setY(Float y) {
            this.y = y;
        }

        public Landmark build() {
            return new Landmark(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Landmark> {
        public Builder type(String var1);

        public Builder type(LandmarkType var1);

        public Builder x(Float var1);

        public Builder y(Float var1);
    }
}

