/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.rekognition.model.CollectionIdListCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListCollectionsResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, ListCollectionsResponse> {
    private final List<String> collectionIds;
    private final String nextToken;

    private ListCollectionsResponse(BuilderImpl builder) {
        super(builder);
        this.collectionIds = builder.collectionIds;
        this.nextToken = builder.nextToken;
    }

    public List<String> collectionIds() {
        return this.collectionIds;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCollectionsResponse)) {
            return false;
        }
        ListCollectionsResponse other = (ListCollectionsResponse)((Object)obj);
        return Objects.equals(this.collectionIds(), other.collectionIds()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListCollectionsResponse").add("CollectionIds", this.collectionIds()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CollectionIds": {
                return Optional.of(clazz.cast(this.collectionIds()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private List<String> collectionIds;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCollectionsResponse model) {
            super(model);
            this.collectionIds(model.collectionIds);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getCollectionIds() {
            return this.collectionIds;
        }

        @Override
        public final Builder collectionIds(Collection<String> collectionIds) {
            this.collectionIds = CollectionIdListCopier.copy(collectionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collectionIds(String ... collectionIds) {
            this.collectionIds(Arrays.asList(collectionIds));
            return this;
        }

        public final void setCollectionIds(Collection<String> collectionIds) {
            this.collectionIds = CollectionIdListCopier.copy(collectionIds);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListCollectionsResponse build() {
            return new ListCollectionsResponse(this);
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    CopyableBuilder<Builder, ListCollectionsResponse> {
        public Builder collectionIds(Collection<String> var1);

        public Builder collectionIds(String ... var1);

        public Builder nextToken(String var1);
    }
}

