/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.DetectLabelsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DetectLabelsRequestModelMarshaller {
    private static final MarshallingInfo<StructuredPojo> IMAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Image").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXLABELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxLabels").isBinary(false).build();
    private static final MarshallingInfo<Float> MINCONFIDENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MinConfidence").isBinary(false).build();
    private static final DetectLabelsRequestModelMarshaller INSTANCE = new DetectLabelsRequestModelMarshaller();

    private DetectLabelsRequestModelMarshaller() {
    }

    public static DetectLabelsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DetectLabelsRequest detectLabelsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)detectLabelsRequest), (String)"detectLabelsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)detectLabelsRequest.image(), IMAGE_BINDING);
            protocolMarshaller.marshall((Object)detectLabelsRequest.maxLabels(), MAXLABELS_BINDING);
            protocolMarshaller.marshall((Object)detectLabelsRequest.minConfidence(), MINCONFIDENCE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

