/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.FaceDetail;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FaceDetailMarshaller {
    private static final MarshallingInfo<StructuredPojo> BOUNDINGBOX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BoundingBox").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> AGERANGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AgeRange").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SMILE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Smile").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> EYEGLASSES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Eyeglasses").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SUNGLASSES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Sunglasses").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> GENDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Gender").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> BEARD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Beard").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> MUSTACHE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Mustache").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> EYESOPEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EyesOpen").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> MOUTHOPEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MouthOpen").isBinary(false).build();
    private static final MarshallingInfo<List> EMOTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Emotions").isBinary(false).build();
    private static final MarshallingInfo<List> LANDMARKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Landmarks").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> POSE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Pose").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> QUALITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Quality").isBinary(false).build();
    private static final MarshallingInfo<Float> CONFIDENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Confidence").isBinary(false).build();
    private static final FaceDetailMarshaller INSTANCE = new FaceDetailMarshaller();

    private FaceDetailMarshaller() {
    }

    public static FaceDetailMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FaceDetail faceDetail, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)faceDetail, (String)"faceDetail");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)faceDetail.boundingBox(), BOUNDINGBOX_BINDING);
            protocolMarshaller.marshall((Object)faceDetail.ageRange(), AGERANGE_BINDING);
            protocolMarshaller.marshall((Object)faceDetail.smile(), SMILE_BINDING);
            protocolMarshaller.marshall((Object)faceDetail.eyeglasses(), EYEGLASSES_BINDING);
            protocolMarshaller.marshall((Object)faceDetail.sunglasses(), SUNGLASSES_BINDING);
            protocolMarshaller.marshall((Object)faceDetail.gender(), GENDER_BINDING);
            protocolMarshaller.marshall((Object)faceDetail.beard(), BEARD_BINDING);
            protocolMarshaller.marshall((Object)faceDetail.mustache(), MUSTACHE_BINDING);
            protocolMarshaller.marshall((Object)faceDetail.eyesOpen(), EYESOPEN_BINDING);
            protocolMarshaller.marshall((Object)faceDetail.mouthOpen(), MOUTHOPEN_BINDING);
            protocolMarshaller.marshall(faceDetail.emotions(), EMOTIONS_BINDING);
            protocolMarshaller.marshall(faceDetail.landmarks(), LANDMARKS_BINDING);
            protocolMarshaller.marshall((Object)faceDetail.pose(), POSE_BINDING);
            protocolMarshaller.marshall((Object)faceDetail.quality(), QUALITY_BINDING);
            protocolMarshaller.marshall((Object)faceDetail.confidence(), CONFIDENCE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

