/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCollectionResponse extends RekognitionResponse implements
        ToCopyableBuilder<CreateCollectionResponse.Builder, CreateCollectionResponse> {
    private final Integer statusCode;

    private final String collectionArn;

    private CreateCollectionResponse(BuilderImpl builder) {
        super(builder);
        this.statusCode = builder.statusCode;
        this.collectionArn = builder.collectionArn;
    }

    /**
     * <p>
     * HTTP status code indicating the result of the operation.
     * </p>
     * 
     * @return HTTP status code indicating the result of the operation.
     */
    public Integer statusCode() {
        return statusCode;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the collection. You can use this to manage permissions on your resources.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the collection. You can use this to manage permissions on your resources.
     */
    public String collectionArn() {
        return collectionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(collectionArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCollectionResponse)) {
            return false;
        }
        CreateCollectionResponse other = (CreateCollectionResponse) obj;
        return Objects.equals(statusCode(), other.statusCode()) && Objects.equals(collectionArn(), other.collectionArn());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateCollectionResponse").add("StatusCode", statusCode()).add("CollectionArn", collectionArn())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StatusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        case "CollectionArn":
            return Optional.ofNullable(clazz.cast(collectionArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends RekognitionResponse.Builder, CopyableBuilder<Builder, CreateCollectionResponse> {
        /**
         * <p>
         * HTTP status code indicating the result of the operation.
         * </p>
         * 
         * @param statusCode
         *        HTTP status code indicating the result of the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(Integer statusCode);

        /**
         * <p>
         * Amazon Resource Name (ARN) of the collection. You can use this to manage permissions on your resources.
         * </p>
         * 
         * @param collectionArn
         *        Amazon Resource Name (ARN) of the collection. You can use this to manage permissions on your
         *        resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionArn(String collectionArn);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private Integer statusCode;

        private String collectionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCollectionResponse model) {
            super(model);
            statusCode(model.statusCode);
            collectionArn(model.collectionArn);
        }

        public final Integer getStatusCode() {
            return statusCode;
        }

        @Override
        public final Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public final String getCollectionArn() {
            return collectionArn;
        }

        @Override
        public final Builder collectionArn(String collectionArn) {
            this.collectionArn = collectionArn;
            return this;
        }

        public final void setCollectionArn(String collectionArn) {
            this.collectionArn = collectionArn;
        }

        @Override
        public CreateCollectionResponse build() {
            return new CreateCollectionResponse(this);
        }
    }
}
