/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteFacesResponse extends RekognitionResponse implements
        ToCopyableBuilder<DeleteFacesResponse.Builder, DeleteFacesResponse> {
    private final List<String> deletedFaces;

    private DeleteFacesResponse(BuilderImpl builder) {
        super(builder);
        this.deletedFaces = builder.deletedFaces;
    }

    /**
     * <p>
     * An array of strings (face IDs) of the faces that were deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of strings (face IDs) of the faces that were deleted.
     */
    public List<String> deletedFaces() {
        return deletedFaces;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deletedFaces());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFacesResponse)) {
            return false;
        }
        DeleteFacesResponse other = (DeleteFacesResponse) obj;
        return Objects.equals(deletedFaces(), other.deletedFaces());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteFacesResponse").add("DeletedFaces", deletedFaces()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeletedFaces":
            return Optional.ofNullable(clazz.cast(deletedFaces()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends RekognitionResponse.Builder, CopyableBuilder<Builder, DeleteFacesResponse> {
        /**
         * <p>
         * An array of strings (face IDs) of the faces that were deleted.
         * </p>
         * 
         * @param deletedFaces
         *        An array of strings (face IDs) of the faces that were deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletedFaces(Collection<String> deletedFaces);

        /**
         * <p>
         * An array of strings (face IDs) of the faces that were deleted.
         * </p>
         * 
         * @param deletedFaces
         *        An array of strings (face IDs) of the faces that were deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletedFaces(String... deletedFaces);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private List<String> deletedFaces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFacesResponse model) {
            super(model);
            deletedFaces(model.deletedFaces);
        }

        public final Collection<String> getDeletedFaces() {
            return deletedFaces;
        }

        @Override
        public final Builder deletedFaces(Collection<String> deletedFaces) {
            this.deletedFaces = FaceIdListCopier.copy(deletedFaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deletedFaces(String... deletedFaces) {
            deletedFaces(Arrays.asList(deletedFaces));
            return this;
        }

        public final void setDeletedFaces(Collection<String> deletedFaces) {
            this.deletedFaces = FaceIdListCopier.copy(deletedFaces);
        }

        @Override
        public DeleteFacesResponse build() {
            return new DeleteFacesResponse(this);
        }
    }
}
