/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCollectionsResponse extends RekognitionResponse implements
        ToCopyableBuilder<ListCollectionsResponse.Builder, ListCollectionsResponse> {
    private final List<String> collectionIds;

    private final String nextToken;

    private ListCollectionsResponse(BuilderImpl builder) {
        super(builder);
        this.collectionIds = builder.collectionIds;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An array of collection IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of collection IDs.
     */
    public List<String> collectionIds() {
        return collectionIds;
    }

    /**
     * <p>
     * If the result is truncated, the response provides a <code>NextToken</code> that you can use in the subsequent
     * request to fetch the next set of collection IDs.
     * </p>
     * 
     * @return If the result is truncated, the response provides a <code>NextToken</code> that you can use in the
     *         subsequent request to fetch the next set of collection IDs.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(collectionIds());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCollectionsResponse)) {
            return false;
        }
        ListCollectionsResponse other = (ListCollectionsResponse) obj;
        return Objects.equals(collectionIds(), other.collectionIds()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListCollectionsResponse").add("CollectionIds", collectionIds()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CollectionIds":
            return Optional.ofNullable(clazz.cast(collectionIds()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends RekognitionResponse.Builder, CopyableBuilder<Builder, ListCollectionsResponse> {
        /**
         * <p>
         * An array of collection IDs.
         * </p>
         * 
         * @param collectionIds
         *        An array of collection IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionIds(Collection<String> collectionIds);

        /**
         * <p>
         * An array of collection IDs.
         * </p>
         * 
         * @param collectionIds
         *        An array of collection IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionIds(String... collectionIds);

        /**
         * <p>
         * If the result is truncated, the response provides a <code>NextToken</code> that you can use in the subsequent
         * request to fetch the next set of collection IDs.
         * </p>
         * 
         * @param nextToken
         *        If the result is truncated, the response provides a <code>NextToken</code> that you can use in the
         *        subsequent request to fetch the next set of collection IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private List<String> collectionIds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCollectionsResponse model) {
            super(model);
            collectionIds(model.collectionIds);
            nextToken(model.nextToken);
        }

        public final Collection<String> getCollectionIds() {
            return collectionIds;
        }

        @Override
        public final Builder collectionIds(Collection<String> collectionIds) {
            this.collectionIds = CollectionIdListCopier.copy(collectionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collectionIds(String... collectionIds) {
            collectionIds(Arrays.asList(collectionIds));
            return this;
        }

        public final void setCollectionIds(Collection<String> collectionIds) {
            this.collectionIds = CollectionIdListCopier.copy(collectionIds);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListCollectionsResponse build() {
            return new ListCollectionsResponse(this);
        }
    }
}
