/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFacesResponse extends RekognitionResponse implements
        ToCopyableBuilder<ListFacesResponse.Builder, ListFacesResponse> {
    private final List<Face> faces;

    private final String nextToken;

    private ListFacesResponse(BuilderImpl builder) {
        super(builder);
        this.faces = builder.faces;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An array of <code>Face</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>Face</code> objects.
     */
    public List<Face> faces() {
        return faces;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Rekognition returns this token that you can use in the subsequent request to
     * retrieve the next set of faces.
     * </p>
     * 
     * @return If the response is truncated, Amazon Rekognition returns this token that you can use in the subsequent
     *         request to retrieve the next set of faces.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(faces());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFacesResponse)) {
            return false;
        }
        ListFacesResponse other = (ListFacesResponse) obj;
        return Objects.equals(faces(), other.faces()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListFacesResponse").add("Faces", faces()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Faces":
            return Optional.ofNullable(clazz.cast(faces()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends RekognitionResponse.Builder, CopyableBuilder<Builder, ListFacesResponse> {
        /**
         * <p>
         * An array of <code>Face</code> objects.
         * </p>
         * 
         * @param faces
         *        An array of <code>Face</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faces(Collection<Face> faces);

        /**
         * <p>
         * An array of <code>Face</code> objects.
         * </p>
         * 
         * @param faces
         *        An array of <code>Face</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faces(Face... faces);

        /**
         * <p>
         * An array of <code>Face</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Face>.Builder} avoiding the need to create
         * one manually via {@link List<Face>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Face>.Builder#build()} is called immediately and its result
         * is passed to {@link #faces(List<Face>)}.
         * 
         * @param faces
         *        a consumer that will call methods on {@link List<Face>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #faces(List<Face>)
         */
        Builder faces(Consumer<Face.Builder>... faces);

        /**
         * <p>
         * If the response is truncated, Amazon Rekognition returns this token that you can use in the subsequent
         * request to retrieve the next set of faces.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon Rekognition returns this token that you can use in the subsequent
         *        request to retrieve the next set of faces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private List<Face> faces = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFacesResponse model) {
            super(model);
            faces(model.faces);
            nextToken(model.nextToken);
        }

        public final Collection<Face.Builder> getFaces() {
            return faces != null ? faces.stream().map(Face::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder faces(Collection<Face> faces) {
            this.faces = FaceListCopier.copy(faces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faces(Face... faces) {
            faces(Arrays.asList(faces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faces(Consumer<Face.Builder>... faces) {
            faces(Stream.of(faces).map(c -> Face.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFaces(Collection<Face.BuilderImpl> faces) {
            this.faces = FaceListCopier.copyFromBuilder(faces);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListFacesResponse build() {
            return new ListFacesResponse(this);
        }
    }
}
