/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchFacesByImageResponse extends RekognitionResponse implements
        ToCopyableBuilder<SearchFacesByImageResponse.Builder, SearchFacesByImageResponse> {
    private final BoundingBox searchedFaceBoundingBox;

    private final Float searchedFaceConfidence;

    private final List<FaceMatch> faceMatches;

    private SearchFacesByImageResponse(BuilderImpl builder) {
        super(builder);
        this.searchedFaceBoundingBox = builder.searchedFaceBoundingBox;
        this.searchedFaceConfidence = builder.searchedFaceConfidence;
        this.faceMatches = builder.faceMatches;
    }

    /**
     * <p>
     * The bounding box around the face in the input image that Amazon Rekognition used for the search.
     * </p>
     * 
     * @return The bounding box around the face in the input image that Amazon Rekognition used for the search.
     */
    public BoundingBox searchedFaceBoundingBox() {
        return searchedFaceBoundingBox;
    }

    /**
     * <p>
     * The level of confidence that the <code>searchedFaceBoundingBox</code>, contains a face.
     * </p>
     * 
     * @return The level of confidence that the <code>searchedFaceBoundingBox</code>, contains a face.
     */
    public Float searchedFaceConfidence() {
        return searchedFaceConfidence;
    }

    /**
     * <p>
     * An array of faces that match the input face, along with the confidence in the match.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of faces that match the input face, along with the confidence in the match.
     */
    public List<FaceMatch> faceMatches() {
        return faceMatches;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(searchedFaceBoundingBox());
        hashCode = 31 * hashCode + Objects.hashCode(searchedFaceConfidence());
        hashCode = 31 * hashCode + Objects.hashCode(faceMatches());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchFacesByImageResponse)) {
            return false;
        }
        SearchFacesByImageResponse other = (SearchFacesByImageResponse) obj;
        return Objects.equals(searchedFaceBoundingBox(), other.searchedFaceBoundingBox())
                && Objects.equals(searchedFaceConfidence(), other.searchedFaceConfidence())
                && Objects.equals(faceMatches(), other.faceMatches());
    }

    @Override
    public String toString() {
        return ToString.builder("SearchFacesByImageResponse").add("SearchedFaceBoundingBox", searchedFaceBoundingBox())
                .add("SearchedFaceConfidence", searchedFaceConfidence()).add("FaceMatches", faceMatches()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SearchedFaceBoundingBox":
            return Optional.ofNullable(clazz.cast(searchedFaceBoundingBox()));
        case "SearchedFaceConfidence":
            return Optional.ofNullable(clazz.cast(searchedFaceConfidence()));
        case "FaceMatches":
            return Optional.ofNullable(clazz.cast(faceMatches()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends RekognitionResponse.Builder, CopyableBuilder<Builder, SearchFacesByImageResponse> {
        /**
         * <p>
         * The bounding box around the face in the input image that Amazon Rekognition used for the search.
         * </p>
         * 
         * @param searchedFaceBoundingBox
         *        The bounding box around the face in the input image that Amazon Rekognition used for the search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchedFaceBoundingBox(BoundingBox searchedFaceBoundingBox);

        /**
         * <p>
         * The bounding box around the face in the input image that Amazon Rekognition used for the search.
         * </p>
         * This is a convenience that creates an instance of the {@link BoundingBox.Builder} avoiding the need to create
         * one manually via {@link BoundingBox#builder()}.
         *
         * When the {@link Consumer} completes, {@link BoundingBox.Builder#build()} is called immediately and its result
         * is passed to {@link #searchedFaceBoundingBox(BoundingBox)}.
         * 
         * @param searchedFaceBoundingBox
         *        a consumer that will call methods on {@link BoundingBox.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchedFaceBoundingBox(BoundingBox)
         */
        default Builder searchedFaceBoundingBox(Consumer<BoundingBox.Builder> searchedFaceBoundingBox) {
            return searchedFaceBoundingBox(BoundingBox.builder().applyMutation(searchedFaceBoundingBox).build());
        }

        /**
         * <p>
         * The level of confidence that the <code>searchedFaceBoundingBox</code>, contains a face.
         * </p>
         * 
         * @param searchedFaceConfidence
         *        The level of confidence that the <code>searchedFaceBoundingBox</code>, contains a face.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchedFaceConfidence(Float searchedFaceConfidence);

        /**
         * <p>
         * An array of faces that match the input face, along with the confidence in the match.
         * </p>
         * 
         * @param faceMatches
         *        An array of faces that match the input face, along with the confidence in the match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceMatches(Collection<FaceMatch> faceMatches);

        /**
         * <p>
         * An array of faces that match the input face, along with the confidence in the match.
         * </p>
         * 
         * @param faceMatches
         *        An array of faces that match the input face, along with the confidence in the match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceMatches(FaceMatch... faceMatches);

        /**
         * <p>
         * An array of faces that match the input face, along with the confidence in the match.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FaceMatch>.Builder} avoiding the need to
         * create one manually via {@link List<FaceMatch>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FaceMatch>.Builder#build()} is called immediately and its
         * result is passed to {@link #faceMatches(List<FaceMatch>)}.
         * 
         * @param faceMatches
         *        a consumer that will call methods on {@link List<FaceMatch>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #faceMatches(List<FaceMatch>)
         */
        Builder faceMatches(Consumer<FaceMatch.Builder>... faceMatches);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private BoundingBox searchedFaceBoundingBox;

        private Float searchedFaceConfidence;

        private List<FaceMatch> faceMatches = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchFacesByImageResponse model) {
            super(model);
            searchedFaceBoundingBox(model.searchedFaceBoundingBox);
            searchedFaceConfidence(model.searchedFaceConfidence);
            faceMatches(model.faceMatches);
        }

        public final BoundingBox.Builder getSearchedFaceBoundingBox() {
            return searchedFaceBoundingBox != null ? searchedFaceBoundingBox.toBuilder() : null;
        }

        @Override
        public final Builder searchedFaceBoundingBox(BoundingBox searchedFaceBoundingBox) {
            this.searchedFaceBoundingBox = searchedFaceBoundingBox;
            return this;
        }

        public final void setSearchedFaceBoundingBox(BoundingBox.BuilderImpl searchedFaceBoundingBox) {
            this.searchedFaceBoundingBox = searchedFaceBoundingBox != null ? searchedFaceBoundingBox.build() : null;
        }

        public final Float getSearchedFaceConfidence() {
            return searchedFaceConfidence;
        }

        @Override
        public final Builder searchedFaceConfidence(Float searchedFaceConfidence) {
            this.searchedFaceConfidence = searchedFaceConfidence;
            return this;
        }

        public final void setSearchedFaceConfidence(Float searchedFaceConfidence) {
            this.searchedFaceConfidence = searchedFaceConfidence;
        }

        public final Collection<FaceMatch.Builder> getFaceMatches() {
            return faceMatches != null ? faceMatches.stream().map(FaceMatch::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder faceMatches(Collection<FaceMatch> faceMatches) {
            this.faceMatches = FaceMatchListCopier.copy(faceMatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceMatches(FaceMatch... faceMatches) {
            faceMatches(Arrays.asList(faceMatches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceMatches(Consumer<FaceMatch.Builder>... faceMatches) {
            faceMatches(Stream.of(faceMatches).map(c -> FaceMatch.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFaceMatches(Collection<FaceMatch.BuilderImpl> faceMatches) {
            this.faceMatches = FaceMatchListCopier.copyFromBuilder(faceMatches);
        }

        @Override
        public SearchFacesByImageResponse build() {
            return new SearchFacesByImageResponse(this);
        }
    }
}
