/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.ContentModerationDetectionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a moderation label detection in a stored video.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContentModerationDetection implements StructuredPojo,
        ToCopyableBuilder<ContentModerationDetection.Builder, ContentModerationDetection> {
    private final Long timestamp;

    private final ModerationLabel moderationLabel;

    private ContentModerationDetection(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.moderationLabel = builder.moderationLabel;
    }

    /**
     * <p>
     * Time, in milliseconds from the beginning of the video, that the moderation label was detected.
     * </p>
     * 
     * @return Time, in milliseconds from the beginning of the video, that the moderation label was detected.
     */
    public Long timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The moderation label detected by in the stored video.
     * </p>
     * 
     * @return The moderation label detected by in the stored video.
     */
    public ModerationLabel moderationLabel() {
        return moderationLabel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(moderationLabel());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentModerationDetection)) {
            return false;
        }
        ContentModerationDetection other = (ContentModerationDetection) obj;
        return Objects.equals(timestamp(), other.timestamp()) && Objects.equals(moderationLabel(), other.moderationLabel());
    }

    @Override
    public String toString() {
        return ToString.builder("ContentModerationDetection").add("Timestamp", timestamp())
                .add("ModerationLabel", moderationLabel()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "ModerationLabel":
            return Optional.ofNullable(clazz.cast(moderationLabel()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContentModerationDetectionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ContentModerationDetection> {
        /**
         * <p>
         * Time, in milliseconds from the beginning of the video, that the moderation label was detected.
         * </p>
         * 
         * @param timestamp
         *        Time, in milliseconds from the beginning of the video, that the moderation label was detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Long timestamp);

        /**
         * <p>
         * The moderation label detected by in the stored video.
         * </p>
         * 
         * @param moderationLabel
         *        The moderation label detected by in the stored video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder moderationLabel(ModerationLabel moderationLabel);

        /**
         * <p>
         * The moderation label detected by in the stored video.
         * </p>
         * This is a convenience that creates an instance of the {@link ModerationLabel.Builder} avoiding the need to
         * create one manually via {@link ModerationLabel#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModerationLabel.Builder#build()} is called immediately and its
         * result is passed to {@link #moderationLabel(ModerationLabel)}.
         * 
         * @param moderationLabel
         *        a consumer that will call methods on {@link ModerationLabel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #moderationLabel(ModerationLabel)
         */
        default Builder moderationLabel(Consumer<ModerationLabel.Builder> moderationLabel) {
            return moderationLabel(ModerationLabel.builder().applyMutation(moderationLabel).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Long timestamp;

        private ModerationLabel moderationLabel;

        private BuilderImpl() {
        }

        private BuilderImpl(ContentModerationDetection model) {
            timestamp(model.timestamp);
            moderationLabel(model.moderationLabel);
        }

        public final Long getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        public final ModerationLabel.Builder getModerationLabel() {
            return moderationLabel != null ? moderationLabel.toBuilder() : null;
        }

        @Override
        public final Builder moderationLabel(ModerationLabel moderationLabel) {
            this.moderationLabel = moderationLabel;
            return this;
        }

        public final void setModerationLabel(ModerationLabel.BuilderImpl moderationLabel) {
            this.moderationLabel = moderationLabel != null ? moderationLabel.build() : null;
        }

        @Override
        public ContentModerationDetection build() {
            return new ContentModerationDetection(this);
        }
    }
}
