/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStreamProcessorRequest extends RekognitionRequest implements
        ToCopyableBuilder<CreateStreamProcessorRequest.Builder, CreateStreamProcessorRequest> {
    private final StreamProcessorInput input;

    private final StreamProcessorOutput output;

    private final String name;

    private final StreamProcessorSettings settings;

    private final String roleArn;

    private CreateStreamProcessorRequest(BuilderImpl builder) {
        super(builder);
        this.input = builder.input;
        this.output = builder.output;
        this.name = builder.name;
        this.settings = builder.settings;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * Kinesis video stream stream that provides the source streaming video. If you are using the AWS CLI, the parameter
     * name is <code>StreamProcessorInput</code>.
     * </p>
     * 
     * @return Kinesis video stream stream that provides the source streaming video. If you are using the AWS CLI, the
     *         parameter name is <code>StreamProcessorInput</code>.
     */
    public StreamProcessorInput input() {
        return input;
    }

    /**
     * <p>
     * Kinesis data stream stream to which Amazon Rekognition Video puts the analysis results. If you are using the AWS
     * CLI, the parameter name is <code>StreamProcessorOutput</code>.
     * </p>
     * 
     * @return Kinesis data stream stream to which Amazon Rekognition Video puts the analysis results. If you are using
     *         the AWS CLI, the parameter name is <code>StreamProcessorOutput</code>.
     */
    public StreamProcessorOutput output() {
        return output;
    }

    /**
     * <p>
     * An identifier you assign to the stream processor. You can use <code>Name</code> to manage the stream processor.
     * For example, you can get the current status of the stream processor by calling . <code>Name</code> is idempotent.
     * </p>
     * 
     * @return An identifier you assign to the stream processor. You can use <code>Name</code> to manage the stream
     *         processor. For example, you can get the current status of the stream processor by calling .
     *         <code>Name</code> is idempotent.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Face recognition input parameters to be used by the stream processor. Includes the collection to use for face
     * recognition and the face attributes to detect.
     * </p>
     * 
     * @return Face recognition input parameters to be used by the stream processor. Includes the collection to use for
     *         face recognition and the face attributes to detect.
     */
    public StreamProcessorSettings settings() {
        return settings;
    }

    /**
     * <p>
     * ARN of the IAM role that allows access to the stream processor.
     * </p>
     * 
     * @return ARN of the IAM role that allows access to the stream processor.
     */
    public String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(output());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(settings());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamProcessorRequest)) {
            return false;
        }
        CreateStreamProcessorRequest other = (CreateStreamProcessorRequest) obj;
        return Objects.equals(input(), other.input()) && Objects.equals(output(), other.output())
                && Objects.equals(name(), other.name()) && Objects.equals(settings(), other.settings())
                && Objects.equals(roleArn(), other.roleArn());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateStreamProcessorRequest").add("Input", input()).add("Output", output()).add("Name", name())
                .add("Settings", settings()).add("RoleArn", roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Input":
            return Optional.ofNullable(clazz.cast(input()));
        case "Output":
            return Optional.ofNullable(clazz.cast(output()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Settings":
            return Optional.ofNullable(clazz.cast(settings()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends RekognitionRequest.Builder, CopyableBuilder<Builder, CreateStreamProcessorRequest> {
        /**
         * <p>
         * Kinesis video stream stream that provides the source streaming video. If you are using the AWS CLI, the
         * parameter name is <code>StreamProcessorInput</code>.
         * </p>
         * 
         * @param input
         *        Kinesis video stream stream that provides the source streaming video. If you are using the AWS CLI,
         *        the parameter name is <code>StreamProcessorInput</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(StreamProcessorInput input);

        /**
         * <p>
         * Kinesis video stream stream that provides the source streaming video. If you are using the AWS CLI, the
         * parameter name is <code>StreamProcessorInput</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link StreamProcessorInput.Builder} avoiding the need
         * to create one manually via {@link StreamProcessorInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamProcessorInput.Builder#build()} is called immediately and
         * its result is passed to {@link #input(StreamProcessorInput)}.
         * 
         * @param input
         *        a consumer that will call methods on {@link StreamProcessorInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #input(StreamProcessorInput)
         */
        default Builder input(Consumer<StreamProcessorInput.Builder> input) {
            return input(StreamProcessorInput.builder().applyMutation(input).build());
        }

        /**
         * <p>
         * Kinesis data stream stream to which Amazon Rekognition Video puts the analysis results. If you are using the
         * AWS CLI, the parameter name is <code>StreamProcessorOutput</code>.
         * </p>
         * 
         * @param output
         *        Kinesis data stream stream to which Amazon Rekognition Video puts the analysis results. If you are
         *        using the AWS CLI, the parameter name is <code>StreamProcessorOutput</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(StreamProcessorOutput output);

        /**
         * <p>
         * Kinesis data stream stream to which Amazon Rekognition Video puts the analysis results. If you are using the
         * AWS CLI, the parameter name is <code>StreamProcessorOutput</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link StreamProcessorOutput.Builder} avoiding the need
         * to create one manually via {@link StreamProcessorOutput#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamProcessorOutput.Builder#build()} is called immediately and
         * its result is passed to {@link #output(StreamProcessorOutput)}.
         * 
         * @param output
         *        a consumer that will call methods on {@link StreamProcessorOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #output(StreamProcessorOutput)
         */
        default Builder output(Consumer<StreamProcessorOutput.Builder> output) {
            return output(StreamProcessorOutput.builder().applyMutation(output).build());
        }

        /**
         * <p>
         * An identifier you assign to the stream processor. You can use <code>Name</code> to manage the stream
         * processor. For example, you can get the current status of the stream processor by calling . <code>Name</code>
         * is idempotent.
         * </p>
         * 
         * @param name
         *        An identifier you assign to the stream processor. You can use <code>Name</code> to manage the stream
         *        processor. For example, you can get the current status of the stream processor by calling .
         *        <code>Name</code> is idempotent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Face recognition input parameters to be used by the stream processor. Includes the collection to use for face
         * recognition and the face attributes to detect.
         * </p>
         * 
         * @param settings
         *        Face recognition input parameters to be used by the stream processor. Includes the collection to use
         *        for face recognition and the face attributes to detect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(StreamProcessorSettings settings);

        /**
         * <p>
         * Face recognition input parameters to be used by the stream processor. Includes the collection to use for face
         * recognition and the face attributes to detect.
         * </p>
         * This is a convenience that creates an instance of the {@link StreamProcessorSettings.Builder} avoiding the
         * need to create one manually via {@link StreamProcessorSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamProcessorSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #settings(StreamProcessorSettings)}.
         * 
         * @param settings
         *        a consumer that will call methods on {@link StreamProcessorSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(StreamProcessorSettings)
         */
        default Builder settings(Consumer<StreamProcessorSettings.Builder> settings) {
            return settings(StreamProcessorSettings.builder().applyMutation(settings).build());
        }

        /**
         * <p>
         * ARN of the IAM role that allows access to the stream processor.
         * </p>
         * 
         * @param roleArn
         *        ARN of the IAM role that allows access to the stream processor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private StreamProcessorInput input;

        private StreamProcessorOutput output;

        private String name;

        private StreamProcessorSettings settings;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamProcessorRequest model) {
            super(model);
            input(model.input);
            output(model.output);
            name(model.name);
            settings(model.settings);
            roleArn(model.roleArn);
        }

        public final StreamProcessorInput.Builder getInput() {
            return input != null ? input.toBuilder() : null;
        }

        @Override
        public final Builder input(StreamProcessorInput input) {
            this.input = input;
            return this;
        }

        public final void setInput(StreamProcessorInput.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        public final StreamProcessorOutput.Builder getOutput() {
            return output != null ? output.toBuilder() : null;
        }

        @Override
        public final Builder output(StreamProcessorOutput output) {
            this.output = output;
            return this;
        }

        public final void setOutput(StreamProcessorOutput.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final StreamProcessorSettings.Builder getSettings() {
            return settings != null ? settings.toBuilder() : null;
        }

        @Override
        public final Builder settings(StreamProcessorSettings settings) {
            this.settings = settings;
            return this;
        }

        public final void setSettings(StreamProcessorSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStreamProcessorRequest build() {
            return new CreateStreamProcessorRequest(this);
        }
    }
}
