/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStreamProcessorResponse extends RekognitionResponse implements
        ToCopyableBuilder<DescribeStreamProcessorResponse.Builder, DescribeStreamProcessorResponse> {
    private final String name;

    private final String streamProcessorArn;

    private final String status;

    private final String statusMessage;

    private final Instant creationTimestamp;

    private final Instant lastUpdateTimestamp;

    private final StreamProcessorInput input;

    private final StreamProcessorOutput output;

    private final String roleArn;

    private final StreamProcessorSettings settings;

    private DescribeStreamProcessorResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.streamProcessorArn = builder.streamProcessorArn;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.creationTimestamp = builder.creationTimestamp;
        this.lastUpdateTimestamp = builder.lastUpdateTimestamp;
        this.input = builder.input;
        this.output = builder.output;
        this.roleArn = builder.roleArn;
        this.settings = builder.settings;
    }

    /**
     * <p>
     * Name of the stream processor.
     * </p>
     * 
     * @return Name of the stream processor.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * ARN of the stream processor.
     * </p>
     * 
     * @return ARN of the stream processor.
     */
    public String streamProcessorArn() {
        return streamProcessorArn;
    }

    /**
     * <p>
     * Current status of the stream processor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StreamProcessorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Current status of the stream processor.
     * @see StreamProcessorStatus
     */
    public StreamProcessorStatus status() {
        return StreamProcessorStatus.fromValue(status);
    }

    /**
     * <p>
     * Current status of the stream processor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StreamProcessorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Current status of the stream processor.
     * @see StreamProcessorStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Detailed status message about the stream processor.
     * </p>
     * 
     * @return Detailed status message about the stream processor.
     */
    public String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * Date and time the stream processor was created
     * </p>
     * 
     * @return Date and time the stream processor was created
     */
    public Instant creationTimestamp() {
        return creationTimestamp;
    }

    /**
     * <p>
     * The time, in Unix format, the stream processor was last updated. For example, when the stream processor moves
     * from a running state to a failed state, or when the user starts or stops the stream processor.
     * </p>
     * 
     * @return The time, in Unix format, the stream processor was last updated. For example, when the stream processor
     *         moves from a running state to a failed state, or when the user starts or stops the stream processor.
     */
    public Instant lastUpdateTimestamp() {
        return lastUpdateTimestamp;
    }

    /**
     * <p>
     * Kinesis video stream that provides the source streaming video.
     * </p>
     * 
     * @return Kinesis video stream that provides the source streaming video.
     */
    public StreamProcessorInput input() {
        return input;
    }

    /**
     * <p>
     * Kinesis data stream to which Amazon Rekognition Video puts the analysis results.
     * </p>
     * 
     * @return Kinesis data stream to which Amazon Rekognition Video puts the analysis results.
     */
    public StreamProcessorOutput output() {
        return output;
    }

    /**
     * <p>
     * ARN of the IAM role that allows access to the stream processor.
     * </p>
     * 
     * @return ARN of the IAM role that allows access to the stream processor.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Face recognition input parameters that are being used by the stream processor. Includes the collection to use for
     * face recognition and the face attributes to detect.
     * </p>
     * 
     * @return Face recognition input parameters that are being used by the stream processor. Includes the collection to
     *         use for face recognition and the face attributes to detect.
     */
    public StreamProcessorSettings settings() {
        return settings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(streamProcessorArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(output());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(settings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStreamProcessorResponse)) {
            return false;
        }
        DescribeStreamProcessorResponse other = (DescribeStreamProcessorResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(streamProcessorArn(), other.streamProcessorArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(creationTimestamp(), other.creationTimestamp())
                && Objects.equals(lastUpdateTimestamp(), other.lastUpdateTimestamp()) && Objects.equals(input(), other.input())
                && Objects.equals(output(), other.output()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(settings(), other.settings());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeStreamProcessorResponse").add("Name", name())
                .add("StreamProcessorArn", streamProcessorArn()).add("Status", statusAsString())
                .add("StatusMessage", statusMessage()).add("CreationTimestamp", creationTimestamp())
                .add("LastUpdateTimestamp", lastUpdateTimestamp()).add("Input", input()).add("Output", output())
                .add("RoleArn", roleArn()).add("Settings", settings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "StreamProcessorArn":
            return Optional.ofNullable(clazz.cast(streamProcessorArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "CreationTimestamp":
            return Optional.ofNullable(clazz.cast(creationTimestamp()));
        case "LastUpdateTimestamp":
            return Optional.ofNullable(clazz.cast(lastUpdateTimestamp()));
        case "Input":
            return Optional.ofNullable(clazz.cast(input()));
        case "Output":
            return Optional.ofNullable(clazz.cast(output()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Settings":
            return Optional.ofNullable(clazz.cast(settings()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends RekognitionResponse.Builder, CopyableBuilder<Builder, DescribeStreamProcessorResponse> {
        /**
         * <p>
         * Name of the stream processor.
         * </p>
         * 
         * @param name
         *        Name of the stream processor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * ARN of the stream processor.
         * </p>
         * 
         * @param streamProcessorArn
         *        ARN of the stream processor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamProcessorArn(String streamProcessorArn);

        /**
         * <p>
         * Current status of the stream processor.
         * </p>
         * 
         * @param status
         *        Current status of the stream processor.
         * @see StreamProcessorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamProcessorStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Current status of the stream processor.
         * </p>
         * 
         * @param status
         *        Current status of the stream processor.
         * @see StreamProcessorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamProcessorStatus
         */
        Builder status(StreamProcessorStatus status);

        /**
         * <p>
         * Detailed status message about the stream processor.
         * </p>
         * 
         * @param statusMessage
         *        Detailed status message about the stream processor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * Date and time the stream processor was created
         * </p>
         * 
         * @param creationTimestamp
         *        Date and time the stream processor was created
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimestamp(Instant creationTimestamp);

        /**
         * <p>
         * The time, in Unix format, the stream processor was last updated. For example, when the stream processor moves
         * from a running state to a failed state, or when the user starts or stops the stream processor.
         * </p>
         * 
         * @param lastUpdateTimestamp
         *        The time, in Unix format, the stream processor was last updated. For example, when the stream
         *        processor moves from a running state to a failed state, or when the user starts or stops the stream
         *        processor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTimestamp(Instant lastUpdateTimestamp);

        /**
         * <p>
         * Kinesis video stream that provides the source streaming video.
         * </p>
         * 
         * @param input
         *        Kinesis video stream that provides the source streaming video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(StreamProcessorInput input);

        /**
         * <p>
         * Kinesis video stream that provides the source streaming video.
         * </p>
         * This is a convenience that creates an instance of the {@link StreamProcessorInput.Builder} avoiding the need
         * to create one manually via {@link StreamProcessorInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamProcessorInput.Builder#build()} is called immediately and
         * its result is passed to {@link #input(StreamProcessorInput)}.
         * 
         * @param input
         *        a consumer that will call methods on {@link StreamProcessorInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #input(StreamProcessorInput)
         */
        default Builder input(Consumer<StreamProcessorInput.Builder> input) {
            return input(StreamProcessorInput.builder().applyMutation(input).build());
        }

        /**
         * <p>
         * Kinesis data stream to which Amazon Rekognition Video puts the analysis results.
         * </p>
         * 
         * @param output
         *        Kinesis data stream to which Amazon Rekognition Video puts the analysis results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(StreamProcessorOutput output);

        /**
         * <p>
         * Kinesis data stream to which Amazon Rekognition Video puts the analysis results.
         * </p>
         * This is a convenience that creates an instance of the {@link StreamProcessorOutput.Builder} avoiding the need
         * to create one manually via {@link StreamProcessorOutput#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamProcessorOutput.Builder#build()} is called immediately and
         * its result is passed to {@link #output(StreamProcessorOutput)}.
         * 
         * @param output
         *        a consumer that will call methods on {@link StreamProcessorOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #output(StreamProcessorOutput)
         */
        default Builder output(Consumer<StreamProcessorOutput.Builder> output) {
            return output(StreamProcessorOutput.builder().applyMutation(output).build());
        }

        /**
         * <p>
         * ARN of the IAM role that allows access to the stream processor.
         * </p>
         * 
         * @param roleArn
         *        ARN of the IAM role that allows access to the stream processor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Face recognition input parameters that are being used by the stream processor. Includes the collection to use
         * for face recognition and the face attributes to detect.
         * </p>
         * 
         * @param settings
         *        Face recognition input parameters that are being used by the stream processor. Includes the collection
         *        to use for face recognition and the face attributes to detect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(StreamProcessorSettings settings);

        /**
         * <p>
         * Face recognition input parameters that are being used by the stream processor. Includes the collection to use
         * for face recognition and the face attributes to detect.
         * </p>
         * This is a convenience that creates an instance of the {@link StreamProcessorSettings.Builder} avoiding the
         * need to create one manually via {@link StreamProcessorSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamProcessorSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #settings(StreamProcessorSettings)}.
         * 
         * @param settings
         *        a consumer that will call methods on {@link StreamProcessorSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(StreamProcessorSettings)
         */
        default Builder settings(Consumer<StreamProcessorSettings.Builder> settings) {
            return settings(StreamProcessorSettings.builder().applyMutation(settings).build());
        }
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private String name;

        private String streamProcessorArn;

        private String status;

        private String statusMessage;

        private Instant creationTimestamp;

        private Instant lastUpdateTimestamp;

        private StreamProcessorInput input;

        private StreamProcessorOutput output;

        private String roleArn;

        private StreamProcessorSettings settings;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStreamProcessorResponse model) {
            super(model);
            name(model.name);
            streamProcessorArn(model.streamProcessorArn);
            status(model.status);
            statusMessage(model.statusMessage);
            creationTimestamp(model.creationTimestamp);
            lastUpdateTimestamp(model.lastUpdateTimestamp);
            input(model.input);
            output(model.output);
            roleArn(model.roleArn);
            settings(model.settings);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStreamProcessorArn() {
            return streamProcessorArn;
        }

        @Override
        public final Builder streamProcessorArn(String streamProcessorArn) {
            this.streamProcessorArn = streamProcessorArn;
            return this;
        }

        public final void setStreamProcessorArn(String streamProcessorArn) {
            this.streamProcessorArn = streamProcessorArn;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StreamProcessorStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Instant getCreationTimestamp() {
            return creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        public final Instant getLastUpdateTimestamp() {
            return lastUpdateTimestamp;
        }

        @Override
        public final Builder lastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
            return this;
        }

        public final void setLastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
        }

        public final StreamProcessorInput.Builder getInput() {
            return input != null ? input.toBuilder() : null;
        }

        @Override
        public final Builder input(StreamProcessorInput input) {
            this.input = input;
            return this;
        }

        public final void setInput(StreamProcessorInput.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        public final StreamProcessorOutput.Builder getOutput() {
            return output != null ? output.toBuilder() : null;
        }

        @Override
        public final Builder output(StreamProcessorOutput output) {
            this.output = output;
            return this;
        }

        public final void setOutput(StreamProcessorOutput.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final StreamProcessorSettings.Builder getSettings() {
            return settings != null ? settings.toBuilder() : null;
        }

        @Override
        public final Builder settings(StreamProcessorSettings settings) {
            this.settings = settings;
            return this;
        }

        public final void setSettings(StreamProcessorSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        public DescribeStreamProcessorResponse build() {
            return new DescribeStreamProcessorResponse(this);
        }
    }
}
