/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.FaceDetectionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a face detected in a video analysis request and the time the face was detected in the video.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FaceDetection implements StructuredPojo, ToCopyableBuilder<FaceDetection.Builder, FaceDetection> {
    private final Long timestamp;

    private final FaceDetail face;

    private FaceDetection(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.face = builder.face;
    }

    /**
     * <p>
     * Time, in milliseconds from the start of the video, that the face was detected.
     * </p>
     * 
     * @return Time, in milliseconds from the start of the video, that the face was detected.
     */
    public Long timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The face properties for the detected face.
     * </p>
     * 
     * @return The face properties for the detected face.
     */
    public FaceDetail face() {
        return face;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(face());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FaceDetection)) {
            return false;
        }
        FaceDetection other = (FaceDetection) obj;
        return Objects.equals(timestamp(), other.timestamp()) && Objects.equals(face(), other.face());
    }

    @Override
    public String toString() {
        return ToString.builder("FaceDetection").add("Timestamp", timestamp()).add("Face", face()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "Face":
            return Optional.ofNullable(clazz.cast(face()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FaceDetectionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, FaceDetection> {
        /**
         * <p>
         * Time, in milliseconds from the start of the video, that the face was detected.
         * </p>
         * 
         * @param timestamp
         *        Time, in milliseconds from the start of the video, that the face was detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Long timestamp);

        /**
         * <p>
         * The face properties for the detected face.
         * </p>
         * 
         * @param face
         *        The face properties for the detected face.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder face(FaceDetail face);

        /**
         * <p>
         * The face properties for the detected face.
         * </p>
         * This is a convenience that creates an instance of the {@link FaceDetail.Builder} avoiding the need to create
         * one manually via {@link FaceDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link FaceDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #face(FaceDetail)}.
         * 
         * @param face
         *        a consumer that will call methods on {@link FaceDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #face(FaceDetail)
         */
        default Builder face(Consumer<FaceDetail.Builder> face) {
            return face(FaceDetail.builder().applyMutation(face).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Long timestamp;

        private FaceDetail face;

        private BuilderImpl() {
        }

        private BuilderImpl(FaceDetection model) {
            timestamp(model.timestamp);
            face(model.face);
        }

        public final Long getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        public final FaceDetail.Builder getFace() {
            return face != null ? face.toBuilder() : null;
        }

        @Override
        public final Builder face(FaceDetail face) {
            this.face = face;
            return this;
        }

        public final void setFace(FaceDetail.BuilderImpl face) {
            this.face = face != null ? face.build() : null;
        }

        @Override
        public FaceDetection build() {
            return new FaceDetection(this);
        }
    }
}
