/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.FaceMatchMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides face metadata. In addition, it also provides the confidence in the match of this face with the input face.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FaceMatch implements StructuredPojo, ToCopyableBuilder<FaceMatch.Builder, FaceMatch> {
    private final Float similarity;

    private final Face face;

    private FaceMatch(BuilderImpl builder) {
        this.similarity = builder.similarity;
        this.face = builder.face;
    }

    /**
     * <p>
     * Confidence in the match of this face with the input face.
     * </p>
     * 
     * @return Confidence in the match of this face with the input face.
     */
    public Float similarity() {
        return similarity;
    }

    /**
     * <p>
     * Describes the face properties such as the bounding box, face ID, image ID of the source image, and external image
     * ID that you assigned.
     * </p>
     * 
     * @return Describes the face properties such as the bounding box, face ID, image ID of the source image, and
     *         external image ID that you assigned.
     */
    public Face face() {
        return face;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(similarity());
        hashCode = 31 * hashCode + Objects.hashCode(face());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FaceMatch)) {
            return false;
        }
        FaceMatch other = (FaceMatch) obj;
        return Objects.equals(similarity(), other.similarity()) && Objects.equals(face(), other.face());
    }

    @Override
    public String toString() {
        return ToString.builder("FaceMatch").add("Similarity", similarity()).add("Face", face()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Similarity":
            return Optional.ofNullable(clazz.cast(similarity()));
        case "Face":
            return Optional.ofNullable(clazz.cast(face()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FaceMatchMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, FaceMatch> {
        /**
         * <p>
         * Confidence in the match of this face with the input face.
         * </p>
         * 
         * @param similarity
         *        Confidence in the match of this face with the input face.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder similarity(Float similarity);

        /**
         * <p>
         * Describes the face properties such as the bounding box, face ID, image ID of the source image, and external
         * image ID that you assigned.
         * </p>
         * 
         * @param face
         *        Describes the face properties such as the bounding box, face ID, image ID of the source image, and
         *        external image ID that you assigned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder face(Face face);

        /**
         * <p>
         * Describes the face properties such as the bounding box, face ID, image ID of the source image, and external
         * image ID that you assigned.
         * </p>
         * This is a convenience that creates an instance of the {@link Face.Builder} avoiding the need to create one
         * manually via {@link Face#builder()}.
         *
         * When the {@link Consumer} completes, {@link Face.Builder#build()} is called immediately and its result is
         * passed to {@link #face(Face)}.
         * 
         * @param face
         *        a consumer that will call methods on {@link Face.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #face(Face)
         */
        default Builder face(Consumer<Face.Builder> face) {
            return face(Face.builder().applyMutation(face).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Float similarity;

        private Face face;

        private BuilderImpl() {
        }

        private BuilderImpl(FaceMatch model) {
            similarity(model.similarity);
            face(model.face);
        }

        public final Float getSimilarity() {
            return similarity;
        }

        @Override
        public final Builder similarity(Float similarity) {
            this.similarity = similarity;
            return this;
        }

        public final void setSimilarity(Float similarity) {
            this.similarity = similarity;
        }

        public final Face.Builder getFace() {
            return face != null ? face.toBuilder() : null;
        }

        @Override
        public final Builder face(Face face) {
            this.face = face;
            return this;
        }

        public final void setFace(Face.BuilderImpl face) {
            this.face = face != null ? face.build() : null;
        }

        @Override
        public FaceMatch build() {
            return new FaceMatch(this);
        }
    }
}
