/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.FaceSearchSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input face recognition parameters for an Amazon Rekognition stream processor. <code>FaceRecognitionSettings</code> is
 * a request parameter for .
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FaceSearchSettings implements StructuredPojo,
        ToCopyableBuilder<FaceSearchSettings.Builder, FaceSearchSettings> {
    private final String collectionId;

    private final Float faceMatchThreshold;

    private FaceSearchSettings(BuilderImpl builder) {
        this.collectionId = builder.collectionId;
        this.faceMatchThreshold = builder.faceMatchThreshold;
    }

    /**
     * <p>
     * The ID of a collection that contains faces that you want to search for.
     * </p>
     * 
     * @return The ID of a collection that contains faces that you want to search for.
     */
    public String collectionId() {
        return collectionId;
    }

    /**
     * <p>
     * Minimum face match confidence score that must be met to return a result for a recognized face. Default is 70. 0
     * is the lowest confidence. 100 is the highest confidence.
     * </p>
     * 
     * @return Minimum face match confidence score that must be met to return a result for a recognized face. Default is
     *         70. 0 is the lowest confidence. 100 is the highest confidence.
     */
    public Float faceMatchThreshold() {
        return faceMatchThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(collectionId());
        hashCode = 31 * hashCode + Objects.hashCode(faceMatchThreshold());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FaceSearchSettings)) {
            return false;
        }
        FaceSearchSettings other = (FaceSearchSettings) obj;
        return Objects.equals(collectionId(), other.collectionId())
                && Objects.equals(faceMatchThreshold(), other.faceMatchThreshold());
    }

    @Override
    public String toString() {
        return ToString.builder("FaceSearchSettings").add("CollectionId", collectionId())
                .add("FaceMatchThreshold", faceMatchThreshold()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CollectionId":
            return Optional.ofNullable(clazz.cast(collectionId()));
        case "FaceMatchThreshold":
            return Optional.ofNullable(clazz.cast(faceMatchThreshold()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FaceSearchSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, FaceSearchSettings> {
        /**
         * <p>
         * The ID of a collection that contains faces that you want to search for.
         * </p>
         * 
         * @param collectionId
         *        The ID of a collection that contains faces that you want to search for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionId(String collectionId);

        /**
         * <p>
         * Minimum face match confidence score that must be met to return a result for a recognized face. Default is 70.
         * 0 is the lowest confidence. 100 is the highest confidence.
         * </p>
         * 
         * @param faceMatchThreshold
         *        Minimum face match confidence score that must be met to return a result for a recognized face. Default
         *        is 70. 0 is the lowest confidence. 100 is the highest confidence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceMatchThreshold(Float faceMatchThreshold);
    }

    static final class BuilderImpl implements Builder {
        private String collectionId;

        private Float faceMatchThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(FaceSearchSettings model) {
            collectionId(model.collectionId);
            faceMatchThreshold(model.faceMatchThreshold);
        }

        public final String getCollectionId() {
            return collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        public final Float getFaceMatchThreshold() {
            return faceMatchThreshold;
        }

        @Override
        public final Builder faceMatchThreshold(Float faceMatchThreshold) {
            this.faceMatchThreshold = faceMatchThreshold;
            return this;
        }

        public final void setFaceMatchThreshold(Float faceMatchThreshold) {
            this.faceMatchThreshold = faceMatchThreshold;
        }

        @Override
        public FaceSearchSettings build() {
            return new FaceSearchSettings(this);
        }
    }
}
