/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLabelDetectionRequest extends RekognitionRequest implements
        ToCopyableBuilder<GetLabelDetectionRequest.Builder, GetLabelDetectionRequest> {
    private final String jobId;

    private final Integer maxResults;

    private final String nextToken;

    private final String sortBy;

    private GetLabelDetectionRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sortBy = builder.sortBy;
    }

    /**
     * <p>
     * Job identifier for the label detection operation for which you want results returned. You get the job identifer
     * from an initial call to <code>StartlabelDetection</code>.
     * </p>
     * 
     * @return Job identifier for the label detection operation for which you want results returned. You get the job
     *         identifer from an initial call to <code>StartlabelDetection</code>.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * Maximum number of results to return per paginated call. The largest value you can specify is 1000. If you specify
     * a value greater than 1000, a maximum of 1000 results is returned. The default value is 1000.
     * </p>
     * 
     * @return Maximum number of results to return per paginated call. The largest value you can specify is 1000. If you
     *         specify a value greater than 1000, a maximum of 1000 results is returned. The default value is 1000.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If the previous response was incomplete (because there are more labels to retrieve), Amazon Rekognition Video
     * returns a pagination token in the response. You can use this pagination token to retrieve the next set of labels.
     * </p>
     * 
     * @return If the previous response was incomplete (because there are more labels to retrieve), Amazon Rekognition
     *         Video returns a pagination token in the response. You can use this pagination token to retrieve the next
     *         set of labels.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Sort to use for elements in the <code>Labels</code> array. Use <code>TIMESTAMP</code> to sort array elements by
     * the time labels are detected. Use <code>NAME</code> to alphabetically group elements for a label together. Within
     * each label group, the array element are sorted by detection confidence. The default sort is by
     * <code>TIMESTAMP</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link LabelDetectionSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortByAsString}.
     * </p>
     * 
     * @return Sort to use for elements in the <code>Labels</code> array. Use <code>TIMESTAMP</code> to sort array
     *         elements by the time labels are detected. Use <code>NAME</code> to alphabetically group elements for a
     *         label together. Within each label group, the array element are sorted by detection confidence. The
     *         default sort is by <code>TIMESTAMP</code>.
     * @see LabelDetectionSortBy
     */
    public LabelDetectionSortBy sortBy() {
        return LabelDetectionSortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * Sort to use for elements in the <code>Labels</code> array. Use <code>TIMESTAMP</code> to sort array elements by
     * the time labels are detected. Use <code>NAME</code> to alphabetically group elements for a label together. Within
     * each label group, the array element are sorted by detection confidence. The default sort is by
     * <code>TIMESTAMP</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link LabelDetectionSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortByAsString}.
     * </p>
     * 
     * @return Sort to use for elements in the <code>Labels</code> array. Use <code>TIMESTAMP</code> to sort array
     *         elements by the time labels are detected. Use <code>NAME</code> to alphabetically group elements for a
     *         label together. Within each label group, the array element are sorted by detection confidence. The
     *         default sort is by <code>TIMESTAMP</code>.
     * @see LabelDetectionSortBy
     */
    public String sortByAsString() {
        return sortBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLabelDetectionRequest)) {
            return false;
        }
        GetLabelDetectionRequest other = (GetLabelDetectionRequest) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(sortByAsString(), other.sortByAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("GetLabelDetectionRequest").add("JobId", jobId()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("SortBy", sortByAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends RekognitionRequest.Builder, CopyableBuilder<Builder, GetLabelDetectionRequest> {
        /**
         * <p>
         * Job identifier for the label detection operation for which you want results returned. You get the job
         * identifer from an initial call to <code>StartlabelDetection</code>.
         * </p>
         * 
         * @param jobId
         *        Job identifier for the label detection operation for which you want results returned. You get the job
         *        identifer from an initial call to <code>StartlabelDetection</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * Maximum number of results to return per paginated call. The largest value you can specify is 1000. If you
         * specify a value greater than 1000, a maximum of 1000 results is returned. The default value is 1000.
         * </p>
         * 
         * @param maxResults
         *        Maximum number of results to return per paginated call. The largest value you can specify is 1000. If
         *        you specify a value greater than 1000, a maximum of 1000 results is returned. The default value is
         *        1000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If the previous response was incomplete (because there are more labels to retrieve), Amazon Rekognition Video
         * returns a pagination token in the response. You can use this pagination token to retrieve the next set of
         * labels.
         * </p>
         * 
         * @param nextToken
         *        If the previous response was incomplete (because there are more labels to retrieve), Amazon
         *        Rekognition Video returns a pagination token in the response. You can use this pagination token to
         *        retrieve the next set of labels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Sort to use for elements in the <code>Labels</code> array. Use <code>TIMESTAMP</code> to sort array elements
         * by the time labels are detected. Use <code>NAME</code> to alphabetically group elements for a label together.
         * Within each label group, the array element are sorted by detection confidence. The default sort is by
         * <code>TIMESTAMP</code>.
         * </p>
         * 
         * @param sortBy
         *        Sort to use for elements in the <code>Labels</code> array. Use <code>TIMESTAMP</code> to sort array
         *        elements by the time labels are detected. Use <code>NAME</code> to alphabetically group elements for a
         *        label together. Within each label group, the array element are sorted by detection confidence. The
         *        default sort is by <code>TIMESTAMP</code>.
         * @see LabelDetectionSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LabelDetectionSortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * Sort to use for elements in the <code>Labels</code> array. Use <code>TIMESTAMP</code> to sort array elements
         * by the time labels are detected. Use <code>NAME</code> to alphabetically group elements for a label together.
         * Within each label group, the array element are sorted by detection confidence. The default sort is by
         * <code>TIMESTAMP</code>.
         * </p>
         * 
         * @param sortBy
         *        Sort to use for elements in the <code>Labels</code> array. Use <code>TIMESTAMP</code> to sort array
         *        elements by the time labels are detected. Use <code>NAME</code> to alphabetically group elements for a
         *        label together. Within each label group, the array element are sorted by detection confidence. The
         *        default sort is by <code>TIMESTAMP</code>.
         * @see LabelDetectionSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LabelDetectionSortBy
         */
        Builder sortBy(LabelDetectionSortBy sortBy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private String jobId;

        private Integer maxResults;

        private String nextToken;

        private String sortBy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLabelDetectionRequest model) {
            super(model);
            jobId(model.jobId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            sortBy(model.sortBy);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getSortBy() {
            return sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(LabelDetectionSortBy sortBy) {
            this.sortBy(sortBy.toString());
            return this;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetLabelDetectionRequest build() {
            return new GetLabelDetectionRequest(this);
        }
    }
}
