/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.ImageQualityMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies face image brightness and sharpness.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageQuality implements StructuredPojo, ToCopyableBuilder<ImageQuality.Builder, ImageQuality> {
    private final Float brightness;

    private final Float sharpness;

    private ImageQuality(BuilderImpl builder) {
        this.brightness = builder.brightness;
        this.sharpness = builder.sharpness;
    }

    /**
     * <p>
     * Value representing brightness of the face. The service returns a value between 0 and 100 (inclusive). A higher
     * value indicates a brighter face image.
     * </p>
     * 
     * @return Value representing brightness of the face. The service returns a value between 0 and 100 (inclusive). A
     *         higher value indicates a brighter face image.
     */
    public Float brightness() {
        return brightness;
    }

    /**
     * <p>
     * Value representing sharpness of the face. The service returns a value between 0 and 100 (inclusive). A higher
     * value indicates a sharper face image.
     * </p>
     * 
     * @return Value representing sharpness of the face. The service returns a value between 0 and 100 (inclusive). A
     *         higher value indicates a sharper face image.
     */
    public Float sharpness() {
        return sharpness;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(brightness());
        hashCode = 31 * hashCode + Objects.hashCode(sharpness());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageQuality)) {
            return false;
        }
        ImageQuality other = (ImageQuality) obj;
        return Objects.equals(brightness(), other.brightness()) && Objects.equals(sharpness(), other.sharpness());
    }

    @Override
    public String toString() {
        return ToString.builder("ImageQuality").add("Brightness", brightness()).add("Sharpness", sharpness()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Brightness":
            return Optional.ofNullable(clazz.cast(brightness()));
        case "Sharpness":
            return Optional.ofNullable(clazz.cast(sharpness()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImageQualityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ImageQuality> {
        /**
         * <p>
         * Value representing brightness of the face. The service returns a value between 0 and 100 (inclusive). A
         * higher value indicates a brighter face image.
         * </p>
         * 
         * @param brightness
         *        Value representing brightness of the face. The service returns a value between 0 and 100 (inclusive).
         *        A higher value indicates a brighter face image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brightness(Float brightness);

        /**
         * <p>
         * Value representing sharpness of the face. The service returns a value between 0 and 100 (inclusive). A higher
         * value indicates a sharper face image.
         * </p>
         * 
         * @param sharpness
         *        Value representing sharpness of the face. The service returns a value between 0 and 100 (inclusive). A
         *        higher value indicates a sharper face image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharpness(Float sharpness);
    }

    static final class BuilderImpl implements Builder {
        private Float brightness;

        private Float sharpness;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageQuality model) {
            brightness(model.brightness);
            sharpness(model.sharpness);
        }

        public final Float getBrightness() {
            return brightness;
        }

        @Override
        public final Builder brightness(Float brightness) {
            this.brightness = brightness;
            return this;
        }

        public final void setBrightness(Float brightness) {
            this.brightness = brightness;
        }

        public final Float getSharpness() {
            return sharpness;
        }

        @Override
        public final Builder sharpness(Float sharpness) {
            this.sharpness = sharpness;
            return this;
        }

        public final void setSharpness(Float sharpness) {
            this.sharpness = sharpness;
        }

        @Override
        public ImageQuality build() {
            return new ImageQuality(this);
        }
    }
}
