/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.LabelDetectionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a label detected in a video analysis request and the time the label was detected in the video.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LabelDetection implements StructuredPojo, ToCopyableBuilder<LabelDetection.Builder, LabelDetection> {
    private final Long timestamp;

    private final Label label;

    private LabelDetection(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.label = builder.label;
    }

    /**
     * <p>
     * Time, in milliseconds from the start of the video, that the label was detected.
     * </p>
     * 
     * @return Time, in milliseconds from the start of the video, that the label was detected.
     */
    public Long timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * Details about the detected label.
     * </p>
     * 
     * @return Details about the detected label.
     */
    public Label label() {
        return label;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(label());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelDetection)) {
            return false;
        }
        LabelDetection other = (LabelDetection) obj;
        return Objects.equals(timestamp(), other.timestamp()) && Objects.equals(label(), other.label());
    }

    @Override
    public String toString() {
        return ToString.builder("LabelDetection").add("Timestamp", timestamp()).add("Label", label()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "Label":
            return Optional.ofNullable(clazz.cast(label()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LabelDetectionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, LabelDetection> {
        /**
         * <p>
         * Time, in milliseconds from the start of the video, that the label was detected.
         * </p>
         * 
         * @param timestamp
         *        Time, in milliseconds from the start of the video, that the label was detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Long timestamp);

        /**
         * <p>
         * Details about the detected label.
         * </p>
         * 
         * @param label
         *        Details about the detected label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(Label label);

        /**
         * <p>
         * Details about the detected label.
         * </p>
         * This is a convenience that creates an instance of the {@link Label.Builder} avoiding the need to create one
         * manually via {@link Label#builder()}.
         *
         * When the {@link Consumer} completes, {@link Label.Builder#build()} is called immediately and its result is
         * passed to {@link #label(Label)}.
         * 
         * @param label
         *        a consumer that will call methods on {@link Label.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #label(Label)
         */
        default Builder label(Consumer<Label.Builder> label) {
            return label(Label.builder().applyMutation(label).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Long timestamp;

        private Label label;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelDetection model) {
            timestamp(model.timestamp);
            label(model.label);
        }

        public final Long getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        public final Label.Builder getLabel() {
            return label != null ? label.toBuilder() : null;
        }

        @Override
        public final Builder label(Label label) {
            this.label = label;
            return this;
        }

        public final void setLabel(Label.BuilderImpl label) {
            this.label = label != null ? label.build() : null;
        }

        @Override
        public LabelDetection build() {
            return new LabelDetection(this);
        }
    }
}
