/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.NotificationChannelMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the completion status of a video
 * analysis operation. For more information, see <a>api-video</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotificationChannel implements StructuredPojo,
        ToCopyableBuilder<NotificationChannel.Builder, NotificationChannel> {
    private final String snsTopicArn;

    private final String roleArn;

    private NotificationChannel(BuilderImpl builder) {
        this.snsTopicArn = builder.snsTopicArn;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The Amazon SNS topic to which Amazon Rekognition to posts the completion status.
     * </p>
     * 
     * @return The Amazon SNS topic to which Amazon Rekognition to posts the completion status.
     */
    public String snsTopicArn() {
        return snsTopicArn;
    }

    /**
     * <p>
     * The ARN of an IAM role that gives Amazon Rekognition publishing permissions to the Amazon SNS topic.
     * </p>
     * 
     * @return The ARN of an IAM role that gives Amazon Rekognition publishing permissions to the Amazon SNS topic.
     */
    public String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationChannel)) {
            return false;
        }
        NotificationChannel other = (NotificationChannel) obj;
        return Objects.equals(snsTopicArn(), other.snsTopicArn()) && Objects.equals(roleArn(), other.roleArn());
    }

    @Override
    public String toString() {
        return ToString.builder("NotificationChannel").add("SNSTopicArn", snsTopicArn()).add("RoleArn", roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SNSTopicArn":
            return Optional.ofNullable(clazz.cast(snsTopicArn()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NotificationChannelMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, NotificationChannel> {
        /**
         * <p>
         * The Amazon SNS topic to which Amazon Rekognition to posts the completion status.
         * </p>
         * 
         * @param snsTopicArn
         *        The Amazon SNS topic to which Amazon Rekognition to posts the completion status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArn(String snsTopicArn);

        /**
         * <p>
         * The ARN of an IAM role that gives Amazon Rekognition publishing permissions to the Amazon SNS topic.
         * </p>
         * 
         * @param roleArn
         *        The ARN of an IAM role that gives Amazon Rekognition publishing permissions to the Amazon SNS topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private String snsTopicArn;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationChannel model) {
            snsTopicArn(model.snsTopicArn);
            roleArn(model.roleArn);
        }

        public final String getSNSTopicArn() {
            return snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final void setSNSTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public NotificationChannel build() {
            return new NotificationChannel(this);
        }
    }
}
