/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.PersonDetectionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details and tracking information for a single time a person is tracked in a video. Amazon Rekognition operations that
 * track persons return an array of <code>PersonDetection</code> objects with elements for each time a person is tracked
 * in a video.
 * </p>
 * <p>
 * For more information, see API_GetPersonTracking in the Amazon Rekognition Developer Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PersonDetection implements StructuredPojo, ToCopyableBuilder<PersonDetection.Builder, PersonDetection> {
    private final Long timestamp;

    private final PersonDetail person;

    private PersonDetection(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.person = builder.person;
    }

    /**
     * <p>
     * The time, in milliseconds from the start of the video, that the person was tracked.
     * </p>
     * 
     * @return The time, in milliseconds from the start of the video, that the person was tracked.
     */
    public Long timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * Details about a person tracked in a video.
     * </p>
     * 
     * @return Details about a person tracked in a video.
     */
    public PersonDetail person() {
        return person;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(person());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PersonDetection)) {
            return false;
        }
        PersonDetection other = (PersonDetection) obj;
        return Objects.equals(timestamp(), other.timestamp()) && Objects.equals(person(), other.person());
    }

    @Override
    public String toString() {
        return ToString.builder("PersonDetection").add("Timestamp", timestamp()).add("Person", person()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "Person":
            return Optional.ofNullable(clazz.cast(person()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PersonDetectionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, PersonDetection> {
        /**
         * <p>
         * The time, in milliseconds from the start of the video, that the person was tracked.
         * </p>
         * 
         * @param timestamp
         *        The time, in milliseconds from the start of the video, that the person was tracked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Long timestamp);

        /**
         * <p>
         * Details about a person tracked in a video.
         * </p>
         * 
         * @param person
         *        Details about a person tracked in a video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder person(PersonDetail person);

        /**
         * <p>
         * Details about a person tracked in a video.
         * </p>
         * This is a convenience that creates an instance of the {@link PersonDetail.Builder} avoiding the need to
         * create one manually via {@link PersonDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link PersonDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #person(PersonDetail)}.
         * 
         * @param person
         *        a consumer that will call methods on {@link PersonDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #person(PersonDetail)
         */
        default Builder person(Consumer<PersonDetail.Builder> person) {
            return person(PersonDetail.builder().applyMutation(person).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Long timestamp;

        private PersonDetail person;

        private BuilderImpl() {
        }

        private BuilderImpl(PersonDetection model) {
            timestamp(model.timestamp);
            person(model.person);
        }

        public final Long getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        public final PersonDetail.Builder getPerson() {
            return person != null ? person.toBuilder() : null;
        }

        @Override
        public final Builder person(PersonDetail person) {
            this.person = person;
            return this;
        }

        public final void setPerson(PersonDetail.BuilderImpl person) {
            this.person = person != null ? person.build() : null;
        }

        @Override
        public PersonDetection build() {
            return new PersonDetection(this);
        }
    }
}
