/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.PointMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The X and Y coordinates of a point on an image. The X and Y values returned are ratios of the overall image size. For
 * example, if the input image is 700x200 and the operation returns X=0.5 and Y=0.25, then the point is at the (350,50)
 * pixel coordinate on the image.
 * </p>
 * <p>
 * An array of <code>Point</code> objects, <code>Polygon</code>, is returned by . <code>Polygon</code> represents a
 * fine-grained polygon around detected text. For more information, see Geometry in the Amazon Rekognition Developer
 * Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Point implements StructuredPojo, ToCopyableBuilder<Point.Builder, Point> {
    private final Float x;

    private final Float y;

    private Point(BuilderImpl builder) {
        this.x = builder.x;
        this.y = builder.y;
    }

    /**
     * <p>
     * The value of the X coordinate for a point on a <code>Polygon</code>.
     * </p>
     * 
     * @return The value of the X coordinate for a point on a <code>Polygon</code>.
     */
    public Float x() {
        return x;
    }

    /**
     * <p>
     * The value of the Y coordinate for a point on a <code>Polygon</code>.
     * </p>
     * 
     * @return The value of the Y coordinate for a point on a <code>Polygon</code>.
     */
    public Float y() {
        return y;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(x());
        hashCode = 31 * hashCode + Objects.hashCode(y());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Point)) {
            return false;
        }
        Point other = (Point) obj;
        return Objects.equals(x(), other.x()) && Objects.equals(y(), other.y());
    }

    @Override
    public String toString() {
        return ToString.builder("Point").add("X", x()).add("Y", y()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "X":
            return Optional.ofNullable(clazz.cast(x()));
        case "Y":
            return Optional.ofNullable(clazz.cast(y()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PointMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Point> {
        /**
         * <p>
         * The value of the X coordinate for a point on a <code>Polygon</code>.
         * </p>
         * 
         * @param x
         *        The value of the X coordinate for a point on a <code>Polygon</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder x(Float x);

        /**
         * <p>
         * The value of the Y coordinate for a point on a <code>Polygon</code>.
         * </p>
         * 
         * @param y
         *        The value of the Y coordinate for a point on a <code>Polygon</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder y(Float y);
    }

    static final class BuilderImpl implements Builder {
        private Float x;

        private Float y;

        private BuilderImpl() {
        }

        private BuilderImpl(Point model) {
            x(model.x);
            y(model.y);
        }

        public final Float getX() {
            return x;
        }

        @Override
        public final Builder x(Float x) {
            this.x = x;
            return this;
        }

        public final void setX(Float x) {
            this.x = x;
        }

        public final Float getY() {
            return y;
        }

        @Override
        public final Builder y(Float y) {
            this.y = y;
            return this;
        }

        public final void setY(Float y) {
            this.y = y;
        }

        @Override
        public Point build() {
            return new Point(this);
        }
    }
}
