/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartPersonTrackingResponse extends RekognitionResponse implements
        ToCopyableBuilder<StartPersonTrackingResponse.Builder, StartPersonTrackingResponse> {
    private final String jobId;

    private StartPersonTrackingResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
    }

    /**
     * <p>
     * The identifier for the person detection job. Use <code>JobId</code> to identify the job in a subsequent call to
     * <code>GetPersonTracking</code>.
     * </p>
     * 
     * @return The identifier for the person detection job. Use <code>JobId</code> to identify the job in a subsequent
     *         call to <code>GetPersonTracking</code>.
     */
    public String jobId() {
        return jobId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartPersonTrackingResponse)) {
            return false;
        }
        StartPersonTrackingResponse other = (StartPersonTrackingResponse) obj;
        return Objects.equals(jobId(), other.jobId());
    }

    @Override
    public String toString() {
        return ToString.builder("StartPersonTrackingResponse").add("JobId", jobId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends RekognitionResponse.Builder, CopyableBuilder<Builder, StartPersonTrackingResponse> {
        /**
         * <p>
         * The identifier for the person detection job. Use <code>JobId</code> to identify the job in a subsequent call
         * to <code>GetPersonTracking</code>.
         * </p>
         * 
         * @param jobId
         *        The identifier for the person detection job. Use <code>JobId</code> to identify the job in a
         *        subsequent call to <code>GetPersonTracking</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private String jobId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartPersonTrackingResponse model) {
            super(model);
            jobId(model.jobId);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public StartPersonTrackingResponse build() {
            return new StartPersonTrackingResponse(this);
        }
    }
}
