/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.StreamProcessorMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that recognizes faces in a streaming video. An Amazon Rekognition stream processor is created by a call to
 * . The request parameters for <code>CreateStreamProcessor</code> describe the Kinesis video stream source for the
 * streaming video, face recognition parameters, and where to stream the analysis resullts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamProcessor implements StructuredPojo, ToCopyableBuilder<StreamProcessor.Builder, StreamProcessor> {
    private final String name;

    private final String status;

    private StreamProcessor(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
    }

    /**
     * <p>
     * Name of the Amazon Rekognition stream processor.
     * </p>
     * 
     * @return Name of the Amazon Rekognition stream processor.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Current status of the Amazon Rekognition stream processor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StreamProcessorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Current status of the Amazon Rekognition stream processor.
     * @see StreamProcessorStatus
     */
    public StreamProcessorStatus status() {
        return StreamProcessorStatus.fromValue(status);
    }

    /**
     * <p>
     * Current status of the Amazon Rekognition stream processor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StreamProcessorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Current status of the Amazon Rekognition stream processor.
     * @see StreamProcessorStatus
     */
    public String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamProcessor)) {
            return false;
        }
        StreamProcessor other = (StreamProcessor) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("StreamProcessor").add("Name", name()).add("Status", statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamProcessorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, StreamProcessor> {
        /**
         * <p>
         * Name of the Amazon Rekognition stream processor.
         * </p>
         * 
         * @param name
         *        Name of the Amazon Rekognition stream processor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Current status of the Amazon Rekognition stream processor.
         * </p>
         * 
         * @param status
         *        Current status of the Amazon Rekognition stream processor.
         * @see StreamProcessorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamProcessorStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Current status of the Amazon Rekognition stream processor.
         * </p>
         * 
         * @param status
         *        Current status of the Amazon Rekognition stream processor.
         * @see StreamProcessorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamProcessorStatus
         */
        Builder status(StreamProcessorStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamProcessor model) {
            name(model.name);
            status(model.status);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StreamProcessorStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public StreamProcessor build() {
            return new StreamProcessor(this);
        }
    }
}
