/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.StreamProcessorInputMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the source streaming video.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamProcessorInput implements StructuredPojo,
        ToCopyableBuilder<StreamProcessorInput.Builder, StreamProcessorInput> {
    private final KinesisVideoStream kinesisVideoStream;

    private StreamProcessorInput(BuilderImpl builder) {
        this.kinesisVideoStream = builder.kinesisVideoStream;
    }

    /**
     * <p>
     * The Kinesis video stream input stream for the source streaming video.
     * </p>
     * 
     * @return The Kinesis video stream input stream for the source streaming video.
     */
    public KinesisVideoStream kinesisVideoStream() {
        return kinesisVideoStream;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kinesisVideoStream());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamProcessorInput)) {
            return false;
        }
        StreamProcessorInput other = (StreamProcessorInput) obj;
        return Objects.equals(kinesisVideoStream(), other.kinesisVideoStream());
    }

    @Override
    public String toString() {
        return ToString.builder("StreamProcessorInput").add("KinesisVideoStream", kinesisVideoStream()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KinesisVideoStream":
            return Optional.ofNullable(clazz.cast(kinesisVideoStream()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamProcessorInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, StreamProcessorInput> {
        /**
         * <p>
         * The Kinesis video stream input stream for the source streaming video.
         * </p>
         * 
         * @param kinesisVideoStream
         *        The Kinesis video stream input stream for the source streaming video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisVideoStream(KinesisVideoStream kinesisVideoStream);

        /**
         * <p>
         * The Kinesis video stream input stream for the source streaming video.
         * </p>
         * This is a convenience that creates an instance of the {@link KinesisVideoStream.Builder} avoiding the need to
         * create one manually via {@link KinesisVideoStream#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisVideoStream.Builder#build()} is called immediately and its
         * result is passed to {@link #kinesisVideoStream(KinesisVideoStream)}.
         * 
         * @param kinesisVideoStream
         *        a consumer that will call methods on {@link KinesisVideoStream.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisVideoStream(KinesisVideoStream)
         */
        default Builder kinesisVideoStream(Consumer<KinesisVideoStream.Builder> kinesisVideoStream) {
            return kinesisVideoStream(KinesisVideoStream.builder().applyMutation(kinesisVideoStream).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private KinesisVideoStream kinesisVideoStream;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamProcessorInput model) {
            kinesisVideoStream(model.kinesisVideoStream);
        }

        public final KinesisVideoStream.Builder getKinesisVideoStream() {
            return kinesisVideoStream != null ? kinesisVideoStream.toBuilder() : null;
        }

        @Override
        public final Builder kinesisVideoStream(KinesisVideoStream kinesisVideoStream) {
            this.kinesisVideoStream = kinesisVideoStream;
            return this;
        }

        public final void setKinesisVideoStream(KinesisVideoStream.BuilderImpl kinesisVideoStream) {
            this.kinesisVideoStream = kinesisVideoStream != null ? kinesisVideoStream.build() : null;
        }

        @Override
        public StreamProcessorInput build() {
            return new StreamProcessorInput(this);
        }
    }
}
