/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.StreamProcessorOutputMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the Amazon Kinesis Data Streams stream to which a Amazon Rekognition Video stream processor streams
 * the results of a video analysis. For more information, see CreateStreamProcessor in the Amazon Rekognition Developer
 * Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamProcessorOutput implements StructuredPojo,
        ToCopyableBuilder<StreamProcessorOutput.Builder, StreamProcessorOutput> {
    private final KinesisDataStream kinesisDataStream;

    private StreamProcessorOutput(BuilderImpl builder) {
        this.kinesisDataStream = builder.kinesisDataStream;
    }

    /**
     * <p>
     * The Amazon Kinesis Data Streams stream to which the Amazon Rekognition stream processor streams the analysis
     * results.
     * </p>
     * 
     * @return The Amazon Kinesis Data Streams stream to which the Amazon Rekognition stream processor streams the
     *         analysis results.
     */
    public KinesisDataStream kinesisDataStream() {
        return kinesisDataStream;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kinesisDataStream());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamProcessorOutput)) {
            return false;
        }
        StreamProcessorOutput other = (StreamProcessorOutput) obj;
        return Objects.equals(kinesisDataStream(), other.kinesisDataStream());
    }

    @Override
    public String toString() {
        return ToString.builder("StreamProcessorOutput").add("KinesisDataStream", kinesisDataStream()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KinesisDataStream":
            return Optional.ofNullable(clazz.cast(kinesisDataStream()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamProcessorOutputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, StreamProcessorOutput> {
        /**
         * <p>
         * The Amazon Kinesis Data Streams stream to which the Amazon Rekognition stream processor streams the analysis
         * results.
         * </p>
         * 
         * @param kinesisDataStream
         *        The Amazon Kinesis Data Streams stream to which the Amazon Rekognition stream processor streams the
         *        analysis results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisDataStream(KinesisDataStream kinesisDataStream);

        /**
         * <p>
         * The Amazon Kinesis Data Streams stream to which the Amazon Rekognition stream processor streams the analysis
         * results.
         * </p>
         * This is a convenience that creates an instance of the {@link KinesisDataStream.Builder} avoiding the need to
         * create one manually via {@link KinesisDataStream#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisDataStream.Builder#build()} is called immediately and its
         * result is passed to {@link #kinesisDataStream(KinesisDataStream)}.
         * 
         * @param kinesisDataStream
         *        a consumer that will call methods on {@link KinesisDataStream.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisDataStream(KinesisDataStream)
         */
        default Builder kinesisDataStream(Consumer<KinesisDataStream.Builder> kinesisDataStream) {
            return kinesisDataStream(KinesisDataStream.builder().applyMutation(kinesisDataStream).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private KinesisDataStream kinesisDataStream;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamProcessorOutput model) {
            kinesisDataStream(model.kinesisDataStream);
        }

        public final KinesisDataStream.Builder getKinesisDataStream() {
            return kinesisDataStream != null ? kinesisDataStream.toBuilder() : null;
        }

        @Override
        public final Builder kinesisDataStream(KinesisDataStream kinesisDataStream) {
            this.kinesisDataStream = kinesisDataStream;
            return this;
        }

        public final void setKinesisDataStream(KinesisDataStream.BuilderImpl kinesisDataStream) {
            this.kinesisDataStream = kinesisDataStream != null ? kinesisDataStream.build() : null;
        }

        @Override
        public StreamProcessorOutput build() {
            return new StreamProcessorOutput(this);
        }
    }
}
