/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.StreamProcessorSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input parameters used to recognize faces in a streaming video analyzed by a Amazon Rekognition stream processor.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamProcessorSettings implements StructuredPojo,
        ToCopyableBuilder<StreamProcessorSettings.Builder, StreamProcessorSettings> {
    private final FaceSearchSettings faceSearch;

    private StreamProcessorSettings(BuilderImpl builder) {
        this.faceSearch = builder.faceSearch;
    }

    /**
     * <p>
     * Face search settings to use on a streaming video.
     * </p>
     * 
     * @return Face search settings to use on a streaming video.
     */
    public FaceSearchSettings faceSearch() {
        return faceSearch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(faceSearch());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamProcessorSettings)) {
            return false;
        }
        StreamProcessorSettings other = (StreamProcessorSettings) obj;
        return Objects.equals(faceSearch(), other.faceSearch());
    }

    @Override
    public String toString() {
        return ToString.builder("StreamProcessorSettings").add("FaceSearch", faceSearch()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FaceSearch":
            return Optional.ofNullable(clazz.cast(faceSearch()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamProcessorSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, StreamProcessorSettings> {
        /**
         * <p>
         * Face search settings to use on a streaming video.
         * </p>
         * 
         * @param faceSearch
         *        Face search settings to use on a streaming video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceSearch(FaceSearchSettings faceSearch);

        /**
         * <p>
         * Face search settings to use on a streaming video.
         * </p>
         * This is a convenience that creates an instance of the {@link FaceSearchSettings.Builder} avoiding the need to
         * create one manually via {@link FaceSearchSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link FaceSearchSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #faceSearch(FaceSearchSettings)}.
         * 
         * @param faceSearch
         *        a consumer that will call methods on {@link FaceSearchSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #faceSearch(FaceSearchSettings)
         */
        default Builder faceSearch(Consumer<FaceSearchSettings.Builder> faceSearch) {
            return faceSearch(FaceSearchSettings.builder().applyMutation(faceSearch).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FaceSearchSettings faceSearch;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamProcessorSettings model) {
            faceSearch(model.faceSearch);
        }

        public final FaceSearchSettings.Builder getFaceSearch() {
            return faceSearch != null ? faceSearch.toBuilder() : null;
        }

        @Override
        public final Builder faceSearch(FaceSearchSettings faceSearch) {
            this.faceSearch = faceSearch;
            return this;
        }

        public final void setFaceSearch(FaceSearchSettings.BuilderImpl faceSearch) {
            this.faceSearch = faceSearch != null ? faceSearch.build() : null;
        }

        @Override
        public StreamProcessorSettings build() {
            return new StreamProcessorSettings(this);
        }
    }
}
