/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.transform;

import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.ComparedFace;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ComparedFace} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ComparedFaceMarshaller {
    private static final MarshallingInfo<StructuredPojo> BOUNDINGBOX_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BoundingBox")
            .isBinary(false).build();

    private static final MarshallingInfo<Float> CONFIDENCE_BINDING = MarshallingInfo.builder(MarshallingType.FLOAT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Confidence").isBinary(false).build();

    private static final MarshallingInfo<List> LANDMARKS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Landmarks").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> POSE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Pose").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> QUALITY_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Quality").isBinary(false).build();

    private static final ComparedFaceMarshaller INSTANCE = new ComparedFaceMarshaller();

    private ComparedFaceMarshaller() {
    }

    public static ComparedFaceMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ComparedFace comparedFace, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(comparedFace, "comparedFace");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(comparedFace.boundingBox(), BOUNDINGBOX_BINDING);
            protocolMarshaller.marshall(comparedFace.confidence(), CONFIDENCE_BINDING);
            protocolMarshaller.marshall(comparedFace.landmarks(), LANDMARKS_BINDING);
            protocolMarshaller.marshall(comparedFace.pose(), POSE_BINDING);
            protocolMarshaller.marshall(comparedFace.quality(), QUALITY_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
