/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.rekognition.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * DescribeStreamProcessorResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeStreamProcessorResponseUnmarshaller implements
        Unmarshaller<DescribeStreamProcessorResponse, JsonUnmarshallerContext> {

    public DescribeStreamProcessorResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        DescribeStreamProcessorResponse.Builder describeStreamProcessorResponseBuilder = DescribeStreamProcessorResponse
                .builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return describeStreamProcessorResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    describeStreamProcessorResponseBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("StreamProcessorArn", targetDepth)) {
                    context.nextToken();
                    describeStreamProcessorResponseBuilder.streamProcessorArn(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    describeStreamProcessorResponseBuilder.status(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("StatusMessage", targetDepth)) {
                    context.nextToken();
                    describeStreamProcessorResponseBuilder.statusMessage(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("CreationTimestamp", targetDepth)) {
                    context.nextToken();
                    describeStreamProcessorResponseBuilder.creationTimestamp(context.getUnmarshaller(java.time.Instant.class)
                            .unmarshall(context));
                }
                if (context.testExpression("LastUpdateTimestamp", targetDepth)) {
                    context.nextToken();
                    describeStreamProcessorResponseBuilder.lastUpdateTimestamp(context.getUnmarshaller(java.time.Instant.class)
                            .unmarshall(context));
                }
                if (context.testExpression("Input", targetDepth)) {
                    context.nextToken();
                    describeStreamProcessorResponseBuilder.input(StreamProcessorInputUnmarshaller.getInstance().unmarshall(
                            context));
                }
                if (context.testExpression("Output", targetDepth)) {
                    context.nextToken();
                    describeStreamProcessorResponseBuilder.output(StreamProcessorOutputUnmarshaller.getInstance().unmarshall(
                            context));
                }
                if (context.testExpression("RoleArn", targetDepth)) {
                    context.nextToken();
                    describeStreamProcessorResponseBuilder.roleArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Settings", targetDepth)) {
                    context.nextToken();
                    describeStreamProcessorResponseBuilder.settings(StreamProcessorSettingsUnmarshaller.getInstance().unmarshall(
                            context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return describeStreamProcessorResponseBuilder.build();
    }

    private static final DescribeStreamProcessorResponseUnmarshaller INSTANCE = new DescribeStreamProcessorResponseUnmarshaller();

    public static DescribeStreamProcessorResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
