/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.rekognition.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * GetContentModerationResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetContentModerationResponseUnmarshaller implements
        Unmarshaller<GetContentModerationResponse, JsonUnmarshallerContext> {

    public GetContentModerationResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        GetContentModerationResponse.Builder getContentModerationResponseBuilder = GetContentModerationResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return getContentModerationResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("JobStatus", targetDepth)) {
                    context.nextToken();
                    getContentModerationResponseBuilder.jobStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("StatusMessage", targetDepth)) {
                    context.nextToken();
                    getContentModerationResponseBuilder.statusMessage(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("VideoMetadata", targetDepth)) {
                    context.nextToken();
                    getContentModerationResponseBuilder
                            .videoMetadata(VideoMetadataUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ModerationLabels", targetDepth)) {
                    context.nextToken();
                    getContentModerationResponseBuilder.moderationLabels(new ListUnmarshaller<ContentModerationDetection>(
                            ContentModerationDetectionUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("NextToken", targetDepth)) {
                    context.nextToken();
                    getContentModerationResponseBuilder.nextToken(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return getContentModerationResponseBuilder.build();
    }

    private static final GetContentModerationResponseUnmarshaller INSTANCE = new GetContentModerationResponseUnmarshaller();

    public static GetContentModerationResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
