/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.rekognition.model.VideoMetadata;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link VideoMetadata} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class VideoMetadataMarshaller {
    private static final MarshallingInfo<String> CODEC_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Codec").isBinary(false).build();

    private static final MarshallingInfo<Long> DURATIONMILLIS_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DurationMillis").isBinary(false).build();

    private static final MarshallingInfo<String> FORMAT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Format").isBinary(false).build();

    private static final MarshallingInfo<Float> FRAMERATE_BINDING = MarshallingInfo.builder(MarshallingType.FLOAT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FrameRate").isBinary(false).build();

    private static final MarshallingInfo<Long> FRAMEHEIGHT_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FrameHeight").isBinary(false).build();

    private static final MarshallingInfo<Long> FRAMEWIDTH_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FrameWidth").isBinary(false).build();

    private static final VideoMetadataMarshaller INSTANCE = new VideoMetadataMarshaller();

    private VideoMetadataMarshaller() {
    }

    public static VideoMetadataMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(VideoMetadata videoMetadata, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(videoMetadata, "videoMetadata");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(videoMetadata.codec(), CODEC_BINDING);
            protocolMarshaller.marshall(videoMetadata.durationMillis(), DURATIONMILLIS_BINDING);
            protocolMarshaller.marshall(videoMetadata.format(), FORMAT_BINDING);
            protocolMarshaller.marshall(videoMetadata.frameRate(), FRAMERATE_BINDING);
            protocolMarshaller.marshall(videoMetadata.frameHeight(), FRAMEHEIGHT_BINDING);
            protocolMarshaller.marshall(videoMetadata.frameWidth(), FRAMEWIDTH_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
