/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.ComparedFace;
import software.amazon.awssdk.services.rekognition.model.UrlsCopier;
import software.amazon.awssdk.services.rekognition.transform.CelebrityMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Celebrity
implements StructuredPojo,
ToCopyableBuilder<Builder, Celebrity> {
    private final List<String> urls;
    private final String name;
    private final String id;
    private final ComparedFace face;
    private final Float matchConfidence;

    private Celebrity(BuilderImpl builder) {
        this.urls = builder.urls;
        this.name = builder.name;
        this.id = builder.id;
        this.face = builder.face;
        this.matchConfidence = builder.matchConfidence;
    }

    public List<String> urls() {
        return this.urls;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ComparedFace face() {
        return this.face;
    }

    public Float matchConfidence() {
        return this.matchConfidence;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.urls());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.face());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchConfidence());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Celebrity)) {
            return false;
        }
        Celebrity other = (Celebrity)obj;
        return Objects.equals(this.urls(), other.urls()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.face(), other.face()) && Objects.equals(this.matchConfidence(), other.matchConfidence());
    }

    public String toString() {
        return ToString.builder((String)"Celebrity").add("Urls", this.urls()).add("Name", (Object)this.name()).add("Id", (Object)this.id()).add("Face", (Object)this.face()).add("MatchConfidence", (Object)this.matchConfidence()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Urls": {
                return Optional.ofNullable(clazz.cast(this.urls()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Face": {
                return Optional.ofNullable(clazz.cast(this.face()));
            }
            case "MatchConfidence": {
                return Optional.ofNullable(clazz.cast(this.matchConfidence()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CelebrityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> urls = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String id;
        private ComparedFace face;
        private Float matchConfidence;

        private BuilderImpl() {
        }

        private BuilderImpl(Celebrity model) {
            this.urls(model.urls);
            this.name(model.name);
            this.id(model.id);
            this.face(model.face);
            this.matchConfidence(model.matchConfidence);
        }

        public final Collection<String> getUrls() {
            return this.urls;
        }

        @Override
        public final Builder urls(Collection<String> urls) {
            this.urls = UrlsCopier.copy(urls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder urls(String ... urls) {
            this.urls(Arrays.asList(urls));
            return this;
        }

        public final void setUrls(Collection<String> urls) {
            this.urls = UrlsCopier.copy(urls);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final ComparedFace.Builder getFace() {
            return this.face != null ? this.face.toBuilder() : null;
        }

        @Override
        public final Builder face(ComparedFace face) {
            this.face = face;
            return this;
        }

        public final void setFace(ComparedFace.BuilderImpl face) {
            this.face = face != null ? face.build() : null;
        }

        public final Float getMatchConfidence() {
            return this.matchConfidence;
        }

        @Override
        public final Builder matchConfidence(Float matchConfidence) {
            this.matchConfidence = matchConfidence;
            return this;
        }

        public final void setMatchConfidence(Float matchConfidence) {
            this.matchConfidence = matchConfidence;
        }

        public Celebrity build() {
            return new Celebrity(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Celebrity> {
        public Builder urls(Collection<String> var1);

        public Builder urls(String ... var1);

        public Builder name(String var1);

        public Builder id(String var1);

        public Builder face(ComparedFace var1);

        default public Builder face(Consumer<ComparedFace.Builder> face) {
            return this.face((ComparedFace)((ComparedFace.Builder)ComparedFace.builder().applyMutation(face)).build());
        }

        public Builder matchConfidence(Float var1);
    }
}

