/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCollectionResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, DescribeCollectionResponse> {
    private final Long faceCount;
    private final String faceModelVersion;
    private final String collectionARN;
    private final Instant creationTimestamp;

    private DescribeCollectionResponse(BuilderImpl builder) {
        super(builder);
        this.faceCount = builder.faceCount;
        this.faceModelVersion = builder.faceModelVersion;
        this.collectionARN = builder.collectionARN;
        this.creationTimestamp = builder.creationTimestamp;
    }

    public Long faceCount() {
        return this.faceCount;
    }

    public String faceModelVersion() {
        return this.faceModelVersion;
    }

    public String collectionARN() {
        return this.collectionARN;
    }

    public Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.faceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.faceModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCollectionResponse)) {
            return false;
        }
        DescribeCollectionResponse other = (DescribeCollectionResponse)((Object)obj);
        return Objects.equals(this.faceCount(), other.faceCount()) && Objects.equals(this.faceModelVersion(), other.faceModelVersion()) && Objects.equals(this.collectionARN(), other.collectionARN()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp());
    }

    public String toString() {
        return ToString.builder((String)"DescribeCollectionResponse").add("FaceCount", (Object)this.faceCount()).add("FaceModelVersion", (Object)this.faceModelVersion()).add("CollectionARN", (Object)this.collectionARN()).add("CreationTimestamp", (Object)this.creationTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FaceCount": {
                return Optional.ofNullable(clazz.cast(this.faceCount()));
            }
            case "FaceModelVersion": {
                return Optional.ofNullable(clazz.cast(this.faceModelVersion()));
            }
            case "CollectionARN": {
                return Optional.ofNullable(clazz.cast(this.collectionARN()));
            }
            case "CreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private Long faceCount;
        private String faceModelVersion;
        private String collectionARN;
        private Instant creationTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCollectionResponse model) {
            super(model);
            this.faceCount(model.faceCount);
            this.faceModelVersion(model.faceModelVersion);
            this.collectionARN(model.collectionARN);
            this.creationTimestamp(model.creationTimestamp);
        }

        public final Long getFaceCount() {
            return this.faceCount;
        }

        @Override
        public final Builder faceCount(Long faceCount) {
            this.faceCount = faceCount;
            return this;
        }

        public final void setFaceCount(Long faceCount) {
            this.faceCount = faceCount;
        }

        public final String getFaceModelVersion() {
            return this.faceModelVersion;
        }

        @Override
        public final Builder faceModelVersion(String faceModelVersion) {
            this.faceModelVersion = faceModelVersion;
            return this;
        }

        public final void setFaceModelVersion(String faceModelVersion) {
            this.faceModelVersion = faceModelVersion;
        }

        public final String getCollectionARN() {
            return this.collectionARN;
        }

        @Override
        public final Builder collectionARN(String collectionARN) {
            this.collectionARN = collectionARN;
            return this;
        }

        public final void setCollectionARN(String collectionARN) {
            this.collectionARN = collectionARN;
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public DescribeCollectionResponse build() {
            return new DescribeCollectionResponse(this);
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    CopyableBuilder<Builder, DescribeCollectionResponse> {
        public Builder faceCount(Long var1);

        public Builder faceModelVersion(String var1);

        public Builder collectionARN(String var1);

        public Builder creationTimestamp(Instant var1);
    }
}

