/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.FaceDetail;
import software.amazon.awssdk.services.rekognition.transform.FaceDetectionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FaceDetection
implements StructuredPojo,
ToCopyableBuilder<Builder, FaceDetection> {
    private final Long timestamp;
    private final FaceDetail face;

    private FaceDetection(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.face = builder.face;
    }

    public Long timestamp() {
        return this.timestamp;
    }

    public FaceDetail face() {
        return this.face;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.face());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FaceDetection)) {
            return false;
        }
        FaceDetection other = (FaceDetection)obj;
        return Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.face(), other.face());
    }

    public String toString() {
        return ToString.builder((String)"FaceDetection").add("Timestamp", (Object)this.timestamp()).add("Face", (Object)this.face()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "Face": {
                return Optional.ofNullable(clazz.cast(this.face()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FaceDetectionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Long timestamp;
        private FaceDetail face;

        private BuilderImpl() {
        }

        private BuilderImpl(FaceDetection model) {
            this.timestamp(model.timestamp);
            this.face(model.face);
        }

        public final Long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        public final FaceDetail.Builder getFace() {
            return this.face != null ? this.face.toBuilder() : null;
        }

        @Override
        public final Builder face(FaceDetail face) {
            this.face = face;
            return this;
        }

        public final void setFace(FaceDetail.BuilderImpl face) {
            this.face = face != null ? face.build() : null;
        }

        public FaceDetection build() {
            return new FaceDetection(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FaceDetection> {
        public Builder timestamp(Long var1);

        public Builder face(FaceDetail var1);

        default public Builder face(Consumer<FaceDetail.Builder> face) {
            return this.face((FaceDetail)((FaceDetail.Builder)FaceDetail.builder().applyMutation(face)).build());
        }
    }
}

