/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.FaceSearchSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FaceSearchSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, FaceSearchSettings> {
    private final String collectionId;
    private final Float faceMatchThreshold;

    private FaceSearchSettings(BuilderImpl builder) {
        this.collectionId = builder.collectionId;
        this.faceMatchThreshold = builder.faceMatchThreshold;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public Float faceMatchThreshold() {
        return this.faceMatchThreshold;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.faceMatchThreshold());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FaceSearchSettings)) {
            return false;
        }
        FaceSearchSettings other = (FaceSearchSettings)obj;
        return Objects.equals(this.collectionId(), other.collectionId()) && Objects.equals(this.faceMatchThreshold(), other.faceMatchThreshold());
    }

    public String toString() {
        return ToString.builder((String)"FaceSearchSettings").add("CollectionId", (Object)this.collectionId()).add("FaceMatchThreshold", (Object)this.faceMatchThreshold()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CollectionId": {
                return Optional.ofNullable(clazz.cast(this.collectionId()));
            }
            case "FaceMatchThreshold": {
                return Optional.ofNullable(clazz.cast(this.faceMatchThreshold()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FaceSearchSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String collectionId;
        private Float faceMatchThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(FaceSearchSettings model) {
            this.collectionId(model.collectionId);
            this.faceMatchThreshold(model.faceMatchThreshold);
        }

        public final String getCollectionId() {
            return this.collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        public final Float getFaceMatchThreshold() {
            return this.faceMatchThreshold;
        }

        @Override
        public final Builder faceMatchThreshold(Float faceMatchThreshold) {
            this.faceMatchThreshold = faceMatchThreshold;
            return this;
        }

        public final void setFaceMatchThreshold(Float faceMatchThreshold) {
            this.faceMatchThreshold = faceMatchThreshold;
        }

        public FaceSearchSettings build() {
            return new FaceSearchSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FaceSearchSettings> {
        public Builder collectionId(String var1);

        public Builder faceMatchThreshold(Float var1);
    }
}

