/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.ContentModerationDetection;
import software.amazon.awssdk.services.rekognition.model.ContentModerationDetectionsCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.services.rekognition.model.VideoJobStatus;
import software.amazon.awssdk.services.rekognition.model.VideoMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetContentModerationResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, GetContentModerationResponse> {
    private final String jobStatus;
    private final String statusMessage;
    private final VideoMetadata videoMetadata;
    private final List<ContentModerationDetection> moderationLabels;
    private final String nextToken;

    private GetContentModerationResponse(BuilderImpl builder) {
        super(builder);
        this.jobStatus = builder.jobStatus;
        this.statusMessage = builder.statusMessage;
        this.videoMetadata = builder.videoMetadata;
        this.moderationLabels = builder.moderationLabels;
        this.nextToken = builder.nextToken;
    }

    public VideoJobStatus jobStatus() {
        return VideoJobStatus.fromValue(this.jobStatus);
    }

    public String jobStatusAsString() {
        return this.jobStatus;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public VideoMetadata videoMetadata() {
        return this.videoMetadata;
    }

    public List<ContentModerationDetection> moderationLabels() {
        return this.moderationLabels;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.moderationLabels());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContentModerationResponse)) {
            return false;
        }
        GetContentModerationResponse other = (GetContentModerationResponse)((Object)obj);
        return Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.videoMetadata(), other.videoMetadata()) && Objects.equals(this.moderationLabels(), other.moderationLabels()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetContentModerationResponse").add("JobStatus", (Object)this.jobStatusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("VideoMetadata", (Object)this.videoMetadata()).add("ModerationLabels", this.moderationLabels()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "VideoMetadata": {
                return Optional.ofNullable(clazz.cast(this.videoMetadata()));
            }
            case "ModerationLabels": {
                return Optional.ofNullable(clazz.cast(this.moderationLabels()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private String jobStatus;
        private String statusMessage;
        private VideoMetadata videoMetadata;
        private List<ContentModerationDetection> moderationLabels = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetContentModerationResponse model) {
            super(model);
            this.jobStatus(model.jobStatus);
            this.statusMessage(model.statusMessage);
            this.videoMetadata(model.videoMetadata);
            this.moderationLabels(model.moderationLabels);
            this.nextToken(model.nextToken);
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(VideoJobStatus jobStatus) {
            this.jobStatus(jobStatus.toString());
            return this;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final VideoMetadata.Builder getVideoMetadata() {
            return this.videoMetadata != null ? this.videoMetadata.toBuilder() : null;
        }

        @Override
        public final Builder videoMetadata(VideoMetadata videoMetadata) {
            this.videoMetadata = videoMetadata;
            return this;
        }

        public final void setVideoMetadata(VideoMetadata.BuilderImpl videoMetadata) {
            this.videoMetadata = videoMetadata != null ? videoMetadata.build() : null;
        }

        public final Collection<ContentModerationDetection.Builder> getModerationLabels() {
            return this.moderationLabels != null ? (Collection)this.moderationLabels.stream().map(ContentModerationDetection::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder moderationLabels(Collection<ContentModerationDetection> moderationLabels) {
            this.moderationLabels = ContentModerationDetectionsCopier.copy(moderationLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder moderationLabels(ContentModerationDetection ... moderationLabels) {
            this.moderationLabels(Arrays.asList(moderationLabels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder moderationLabels(Consumer<ContentModerationDetection.Builder> ... moderationLabels) {
            this.moderationLabels(Stream.of(moderationLabels).map(c -> (ContentModerationDetection)((ContentModerationDetection.Builder)ContentModerationDetection.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setModerationLabels(Collection<ContentModerationDetection.BuilderImpl> moderationLabels) {
            this.moderationLabels = ContentModerationDetectionsCopier.copyFromBuilder(moderationLabels);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetContentModerationResponse build() {
            return new GetContentModerationResponse(this);
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    CopyableBuilder<Builder, GetContentModerationResponse> {
        public Builder jobStatus(String var1);

        public Builder jobStatus(VideoJobStatus var1);

        public Builder statusMessage(String var1);

        public Builder videoMetadata(VideoMetadata var1);

        default public Builder videoMetadata(Consumer<VideoMetadata.Builder> videoMetadata) {
            return this.videoMetadata((VideoMetadata)((VideoMetadata.Builder)VideoMetadata.builder().applyMutation(videoMetadata)).build());
        }

        public Builder moderationLabels(Collection<ContentModerationDetection> var1);

        public Builder moderationLabels(ContentModerationDetection ... var1);

        public Builder moderationLabels(Consumer<ContentModerationDetection.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

