/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.Label;
import software.amazon.awssdk.services.rekognition.transform.LabelDetectionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LabelDetection
implements StructuredPojo,
ToCopyableBuilder<Builder, LabelDetection> {
    private final Long timestamp;
    private final Label label;

    private LabelDetection(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.label = builder.label;
    }

    public Long timestamp() {
        return this.timestamp;
    }

    public Label label() {
        return this.label;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.label());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelDetection)) {
            return false;
        }
        LabelDetection other = (LabelDetection)obj;
        return Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.label(), other.label());
    }

    public String toString() {
        return ToString.builder((String)"LabelDetection").add("Timestamp", (Object)this.timestamp()).add("Label", (Object)this.label()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "Label": {
                return Optional.ofNullable(clazz.cast(this.label()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LabelDetectionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Long timestamp;
        private Label label;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelDetection model) {
            this.timestamp(model.timestamp);
            this.label(model.label);
        }

        public final Long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        public final Label.Builder getLabel() {
            return this.label != null ? this.label.toBuilder() : null;
        }

        @Override
        public final Builder label(Label label) {
            this.label = label;
            return this;
        }

        public final void setLabel(Label.BuilderImpl label) {
            this.label = label != null ? label.build() : null;
        }

        public LabelDetection build() {
            return new LabelDetection(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LabelDetection> {
        public Builder timestamp(Long var1);

        public Builder label(Label var1);

        default public Builder label(Consumer<Label.Builder> label) {
            return this.label((Label)((Label.Builder)Label.builder().applyMutation(label)).build());
        }
    }
}

