/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.BoundingBox;
import software.amazon.awssdk.services.rekognition.model.FaceDetail;
import software.amazon.awssdk.services.rekognition.transform.PersonDetailMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PersonDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, PersonDetail> {
    private final Long index;
    private final BoundingBox boundingBox;
    private final FaceDetail face;

    private PersonDetail(BuilderImpl builder) {
        this.index = builder.index;
        this.boundingBox = builder.boundingBox;
        this.face = builder.face;
    }

    public Long index() {
        return this.index;
    }

    public BoundingBox boundingBox() {
        return this.boundingBox;
    }

    public FaceDetail face() {
        return this.face;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.index());
        hashCode = 31 * hashCode + Objects.hashCode(this.boundingBox());
        hashCode = 31 * hashCode + Objects.hashCode(this.face());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PersonDetail)) {
            return false;
        }
        PersonDetail other = (PersonDetail)obj;
        return Objects.equals(this.index(), other.index()) && Objects.equals(this.boundingBox(), other.boundingBox()) && Objects.equals(this.face(), other.face());
    }

    public String toString() {
        return ToString.builder((String)"PersonDetail").add("Index", (Object)this.index()).add("BoundingBox", (Object)this.boundingBox()).add("Face", (Object)this.face()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Index": {
                return Optional.ofNullable(clazz.cast(this.index()));
            }
            case "BoundingBox": {
                return Optional.ofNullable(clazz.cast(this.boundingBox()));
            }
            case "Face": {
                return Optional.ofNullable(clazz.cast(this.face()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PersonDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Long index;
        private BoundingBox boundingBox;
        private FaceDetail face;

        private BuilderImpl() {
        }

        private BuilderImpl(PersonDetail model) {
            this.index(model.index);
            this.boundingBox(model.boundingBox);
            this.face(model.face);
        }

        public final Long getIndex() {
            return this.index;
        }

        @Override
        public final Builder index(Long index) {
            this.index = index;
            return this;
        }

        public final void setIndex(Long index) {
            this.index = index;
        }

        public final BoundingBox.Builder getBoundingBox() {
            return this.boundingBox != null ? this.boundingBox.toBuilder() : null;
        }

        @Override
        public final Builder boundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        public final void setBoundingBox(BoundingBox.BuilderImpl boundingBox) {
            this.boundingBox = boundingBox != null ? boundingBox.build() : null;
        }

        public final FaceDetail.Builder getFace() {
            return this.face != null ? this.face.toBuilder() : null;
        }

        @Override
        public final Builder face(FaceDetail face) {
            this.face = face;
            return this;
        }

        public final void setFace(FaceDetail.BuilderImpl face) {
            this.face = face != null ? face.build() : null;
        }

        public PersonDetail build() {
            return new PersonDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PersonDetail> {
        public Builder index(Long var1);

        public Builder boundingBox(BoundingBox var1);

        default public Builder boundingBox(Consumer<BoundingBox.Builder> boundingBox) {
            return this.boundingBox((BoundingBox)((BoundingBox.Builder)BoundingBox.builder().applyMutation(boundingBox)).build());
        }

        public Builder face(FaceDetail var1);

        default public Builder face(Consumer<FaceDetail.Builder> face) {
            return this.face((FaceDetail)((FaceDetail.Builder)FaceDetail.builder().applyMutation(face)).build());
        }
    }
}

