/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.FaceMatch;
import software.amazon.awssdk.services.rekognition.model.FaceMatchListCopier;
import software.amazon.awssdk.services.rekognition.model.PersonDetail;
import software.amazon.awssdk.services.rekognition.transform.PersonMatchMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PersonMatch
implements StructuredPojo,
ToCopyableBuilder<Builder, PersonMatch> {
    private final Long timestamp;
    private final PersonDetail person;
    private final List<FaceMatch> faceMatches;

    private PersonMatch(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.person = builder.person;
        this.faceMatches = builder.faceMatches;
    }

    public Long timestamp() {
        return this.timestamp;
    }

    public PersonDetail person() {
        return this.person;
    }

    public List<FaceMatch> faceMatches() {
        return this.faceMatches;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.person());
        hashCode = 31 * hashCode + Objects.hashCode(this.faceMatches());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PersonMatch)) {
            return false;
        }
        PersonMatch other = (PersonMatch)obj;
        return Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.person(), other.person()) && Objects.equals(this.faceMatches(), other.faceMatches());
    }

    public String toString() {
        return ToString.builder((String)"PersonMatch").add("Timestamp", (Object)this.timestamp()).add("Person", (Object)this.person()).add("FaceMatches", this.faceMatches()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "Person": {
                return Optional.ofNullable(clazz.cast(this.person()));
            }
            case "FaceMatches": {
                return Optional.ofNullable(clazz.cast(this.faceMatches()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PersonMatchMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Long timestamp;
        private PersonDetail person;
        private List<FaceMatch> faceMatches = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PersonMatch model) {
            this.timestamp(model.timestamp);
            this.person(model.person);
            this.faceMatches(model.faceMatches);
        }

        public final Long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        public final PersonDetail.Builder getPerson() {
            return this.person != null ? this.person.toBuilder() : null;
        }

        @Override
        public final Builder person(PersonDetail person) {
            this.person = person;
            return this;
        }

        public final void setPerson(PersonDetail.BuilderImpl person) {
            this.person = person != null ? person.build() : null;
        }

        public final Collection<FaceMatch.Builder> getFaceMatches() {
            return this.faceMatches != null ? (Collection)this.faceMatches.stream().map(FaceMatch::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder faceMatches(Collection<FaceMatch> faceMatches) {
            this.faceMatches = FaceMatchListCopier.copy(faceMatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceMatches(FaceMatch ... faceMatches) {
            this.faceMatches(Arrays.asList(faceMatches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceMatches(Consumer<FaceMatch.Builder> ... faceMatches) {
            this.faceMatches(Stream.of(faceMatches).map(c -> (FaceMatch)((FaceMatch.Builder)FaceMatch.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFaceMatches(Collection<FaceMatch.BuilderImpl> faceMatches) {
            this.faceMatches = FaceMatchListCopier.copyFromBuilder(faceMatches);
        }

        public PersonMatch build() {
            return new PersonMatch(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PersonMatch> {
        public Builder timestamp(Long var1);

        public Builder person(PersonDetail var1);

        default public Builder person(Consumer<PersonDetail.Builder> person) {
            return this.person((PersonDetail)((PersonDetail.Builder)PersonDetail.builder().applyMutation(person)).build());
        }

        public Builder faceMatches(Collection<FaceMatch> var1);

        public Builder faceMatches(FaceMatch ... var1);

        public Builder faceMatches(Consumer<FaceMatch.Builder> ... var1);
    }
}

