/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.StreamProcessorStatus;
import software.amazon.awssdk.services.rekognition.transform.StreamProcessorMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreamProcessor
implements StructuredPojo,
ToCopyableBuilder<Builder, StreamProcessor> {
    private final String name;
    private final String status;

    private StreamProcessor(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
    }

    public String name() {
        return this.name;
    }

    public StreamProcessorStatus status() {
        return StreamProcessorStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamProcessor)) {
            return false;
        }
        StreamProcessor other = (StreamProcessor)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"StreamProcessor").add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamProcessorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamProcessor model) {
            this.name(model.name);
            this.status(model.status);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StreamProcessorStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public StreamProcessor build() {
            return new StreamProcessor(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StreamProcessor> {
        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(StreamProcessorStatus var1);
    }
}

