/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.CelebrityRecognition;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CelebrityRecognitionMarshaller {
    private static final MarshallingInfo<Long> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timestamp").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CELEBRITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Celebrity").isBinary(false).build();
    private static final CelebrityRecognitionMarshaller INSTANCE = new CelebrityRecognitionMarshaller();

    private CelebrityRecognitionMarshaller() {
    }

    public static CelebrityRecognitionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CelebrityRecognition celebrityRecognition, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)celebrityRecognition, (String)"celebrityRecognition");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)celebrityRecognition.timestamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)celebrityRecognition.celebrity(), CELEBRITY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

