/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.CompareFacesRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CompareFacesRequestModelMarshaller {
    private static final MarshallingInfo<StructuredPojo> SOURCEIMAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceImage").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TARGETIMAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetImage").isBinary(false).build();
    private static final MarshallingInfo<Float> SIMILARITYTHRESHOLD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SimilarityThreshold").isBinary(false).build();
    private static final CompareFacesRequestModelMarshaller INSTANCE = new CompareFacesRequestModelMarshaller();

    private CompareFacesRequestModelMarshaller() {
    }

    public static CompareFacesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CompareFacesRequest compareFacesRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)compareFacesRequest), (String)"compareFacesRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)compareFacesRequest.sourceImage(), SOURCEIMAGE_BINDING);
            protocolMarshaller.marshall((Object)compareFacesRequest.targetImage(), TARGETIMAGE_BINDING);
            protocolMarshaller.marshall((Object)compareFacesRequest.similarityThreshold(), SIMILARITYTHRESHOLD_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

